/*
 * Decompiled with CFR 0.152.
 */
package cycles;

import accessories.Ammo;
import accessories.Bumb;
import cycles.Cycles;
import game.GNSprite;
import game.Game;
import game.ViewPort;
import groups.Group;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AngleEnemy
extends GNSprite {
    static Vector vectorEnemies;
    static Random rndTypes;
    static final int TYPE_RIGHT = 0;
    static final int TYPE_LEFT = 1;
    static int maxNotshot;
    static int notShot;
    static int ammoID;
    static int maxAmmoID;
    private static boolean testedLastEnemy;
    int health = 1;
    int sp = 12;
    int direction;
    int type;
    boolean started = false;
    int IDGroup;

    public static void create() {
        vectorEnemies = new Vector();
        rndTypes = new Random();
    }

    public static void clean() {
        vectorEnemies = null;
        rndTypes = null;
    }

    public static void generate() {
        if (!Cycles.canGenerate) {
            return;
        }
        testedLastEnemy = false;
        notShot = 0;
        AngleEnemy temp = null;
        int type = AngleEnemy.randomType(2);
        Image img = Group.randomImage();
        int height = img.getHeight();
        int width = img.getWidth();
        if (type == 1) {
            temp = new AngleEnemy(img, width, height, type, -1 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -2 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -3 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -4 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -5 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -6 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, -7 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
        } else if (type == 0) {
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 1 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 2 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 3 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 4 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 5 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 6 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
            temp = new AngleEnemy(img, width, height, type, ViewPort.WIDTH + 7 * (width + 5), 0);
            vectorEnemies.addElement(temp);
            Game.addElement(temp);
        }
    }

    public static int randomType(int n) {
        int r = rndTypes.nextInt() % n;
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static int randomAmmo() {
        if (vectorEnemies.size() == 0) {
            return -1;
        }
        int r = rndTypes.nextInt() % (maxAmmoID + 1);
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static void removeEnemy(AngleEnemy enemy) {
        vectorEnemies.removeElement(enemy);
        Game.removeElement(enemy);
        if (vectorEnemies.size() == 0 && !testedLastEnemy) {
            Cycles.canGenerate = true;
        }
    }

    public static void cycleAll() {
        if (notShot == 0) {
            ammoID = AngleEnemy.randomAmmo();
        }
        ++notShot;
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((AngleEnemy)vectorEnemies.elementAt(j)).cycle();
        }
        AngleEnemy.testLastEnemyPlace();
    }

    private static void testLastEnemyPlace() {
        if (testedLastEnemy) {
            return;
        }
        if (vectorEnemies.size() == 0) {
            return;
        }
        try {
            AngleEnemy angleEnemy = (AngleEnemy)vectorEnemies.lastElement();
            if (angleEnemy.getY() > 320) {
                Cycles.canGenerate = true;
                testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawAll(Graphics g) {
        for (int j = 0; j < vectorEnemies.size(); ++j) {
            ((AngleEnemy)vectorEnemies.elementAt(j)).draw(g);
        }
    }

    public AngleEnemy(Image image, int width, int height, int type, int x, int y) {
        super(image, width, height);
        this.setPosition(x, y);
        this.type = type;
        if (type == 1) {
            this.direction = 0;
        } else if (type == 0) {
            this.direction = 8;
        }
        this.IDGroup = vectorEnemies.size();
    }

    public void cycle() {
        if (!this.started) {
            if (this.type == 1) {
                if (this.getX() + this.getWidth() >= 0) {
                    maxAmmoID = this.IDGroup;
                    this.started = true;
                    this.direction = this.type == 1 ? 13 : 11;
                }
            } else if (this.type == 0 && this.getX() <= ViewPort.WIDTH) {
                maxAmmoID = this.IDGroup;
                this.started = true;
                this.direction = this.type == 1 ? 13 : 11;
            }
        }
        this.move();
        if (!this.started) {
            return;
        }
        if (!ViewPort.isBelongToView(this)) {
            AngleEnemy.removeEnemy(this);
            return;
        }
        if (this.collidesWith(Game.player, true)) {
            AngleEnemy.removeEnemy(this);
            Game.player.hit(5);
            return;
        }
        if (notShot >= maxNotshot && ammoID == this.IDGroup) {
            notShot = 0;
        }
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void hit(Ammo ammo) {
        ++Game.player.score;
        this.health -= ammo.type.healthEffect;
        if (this.health <= 0) {
            Bumb.generateOnCondition(Bumb.TYPE1, this.getX() - Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY());
            AngleEnemy.removeEnemy(this);
        }
    }

    static {
        maxNotshot = 5;
        notShot = 0;
        maxAmmoID = 0;
    }
}

