/*
 * Decompiled with CFR 0.152.
 */
package game;

import accessories.Ammo;
import accessories.Bumb;
import accessories.EnemyHealth;
import game.GNSprite;
import game.Game;
import game.Main;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import level2.Level2;
import level3.Level3;

public class Hero
extends GNSprite {
    static int[] xAmmo;
    static Hero hero;
    static Image imgHero;
    static Random rndXAmmo;
    static int maxNotshot;
    static int notShot;
    static Vector lazer;
    static int lazerX;
    static int lazerY;
    static Image imgLazer;
    static int lastStartedLazer;
    int sp = 5;
    int direction = 12;
    int health = 100;
    Random rndAmmo;
    boolean started = false;
    int hitPeriod = 0;
    boolean hitted = false;
    int bumbedTime;

    public static int rndXAmmo() {
        int r = rndXAmmo.nextInt() % xAmmo.length;
        if (r < 0) {
            r *= -1;
        }
        return xAmmo[r];
    }

    public static void createLevel1() {
        xAmmo = new int[]{5, 85};
        lazer = new Vector();
        lastStartedLazer = 0;
        rndXAmmo = new Random();
        try {
            imgLazer = Image.createImage((String)"/lazer.png");
            imgHero = Image.createImage((String)"/hero.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void clean() {
        rndXAmmo = null;
        imgHero = null;
        hero = null;
    }

    public static void createLevel2() {
        xAmmo = new int[]{45, 105, 75};
        lazer = new Vector();
        lastStartedLazer = 0;
        rndXAmmo = new Random();
        try {
            imgLazer = Image.createImage((String)"/level2/laser.png");
            imgHero = Image.createImage((String)"/level2/hero.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createLevel3() {
        xAmmo = new int[]{45, 105, 75};
        lazer = new Vector();
        lastStartedLazer = 0;
        rndXAmmo = new Random();
        try {
            imgLazer = Image.createImage((String)"/lazer.png");
            imgHero = Image.createImage((String)"/level3/hero.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void cleanLevel3() {
        rndXAmmo = null;
        imgHero = null;
        hero = null;
    }

    public static void generate() {
        if (hero != null) {
            return;
        }
        hero = new Hero(imgHero, imgHero.getWidth() / 6, imgHero.getHeight());
        hero.defineCollisionRectangle(28, 30, 50, 33);
        hero.defineCollisionRectangle(40, 60, 45, 20);
        Game.addElement(hero);
    }

    public static void generateLevel2() {
        if (hero != null) {
            return;
        }
        hero = new Hero(imgHero, imgHero.getWidth() / 6, imgHero.getHeight());
        hero.defineCollisionRectangle(43, 69, 14, 11);
        hero.defineCollisionRectangle(70, 114, 27, 20);
        Game.addElement(hero);
    }

    public static void generateLevel3() {
        if (hero != null) {
            return;
        }
        hero = new Hero(imgHero, imgHero.getWidth() / 6, imgHero.getHeight());
        hero.defineCollisionRectangle(45, 30, 52, 56);
        hero.defineCollisionRectangle(60, 110, 70, 40);
        Game.addElement(hero);
    }

    public static void cycleAll() {
        if (hero == null) {
            return;
        }
        ++lastStartedLazer;
        Hero.cycleLazer();
        if (lazer.size() == 0) {
            hero.cycle();
        }
        if (lastStartedLazer >= 100 && Hero.hero.bumbedTime == 0) {
            Hero.startLazer();
            lastStartedLazer = 0;
        }
    }

    public static void drawAll(Graphics g) {
        if (hero == null) {
            return;
        }
        hero.draw(g);
        Hero.drawLazer(g);
    }

    public static void startLazer() {
        lazerX = hero.getX() + hero.getWidth() / 2 - imgLazer.getWidth() / 2;
        lazerY = hero.getY() + hero.getHeight() / 2;
        Sprite temp = new Sprite(imgLazer);
        temp.setPosition(lazerX, lazerY);
        lazer.addElement(temp);
    }

    public static void cycleLazer() {
        if (lazer.size() == 0) {
            return;
        }
        Sprite temp = null;
        temp = (Sprite)lazer.lastElement();
        if (Game.player.collidesWith(temp, true)) {
            Game.player.hit(10);
            Hero.endLazer();
            return;
        }
        if (temp.getY() + temp.getHeight() >= ViewPort.HEIGHT - 1) {
            Hero.endLazer();
            return;
        }
        Sprite temp2 = new Sprite(imgLazer);
        temp2.setPosition(temp.getX(), temp.getY() + temp.getHeight() / 2);
        lazer.addElement(temp2);
    }

    public static void drawLazer(Graphics g) {
        Object temp = null;
        for (int j = 0; j < lazer.size(); ++j) {
            ((Sprite)lazer.elementAt(j)).paint(g);
        }
    }

    public static void endLazer() {
        lazer.removeAllElements();
    }

    public Hero(Image image, int width, int height) {
        super(image, width, height);
        this.setPosition(ViewPort.WIDTH / 2 - this.getWidth() / 2, -this.getHeight());
        if (Game.savedEnemyHealth != -1) {
            this.health = Game.savedEnemyHealth;
            Game.savedEnemyHealth = -1;
        }
    }

    public void move() {
        int errorX = Math.abs(this.tempX - this.getX() * 1000);
        int errorY = Math.abs(this.tempY - this.getY() * 1000);
        if (errorX > 1000 || errorY > 1000) {
            this.tempX = this.getX() * 1000;
            this.tempY = this.getY() * 1000;
        }
        this.tempX += this.sp * Game.cos[this.direction];
        this.tempY -= this.sp * Game.sin[this.direction];
        this.setPosition(this.tempX / 1000, this.tempY / 1000);
    }

    public void cycle() {
        Game.enemyHealthForSave = this.health;
        if (this.bumbedTime > 0) {
            Game.levelFinished = true;
            ++this.bumbedTime;
            if (this.bumbedTime == 5) {
                Bumb.generate(Bumb.TYPE4, this.getX() - Bumb.TYPE4.width / 2, this.getY() + this.getHeight() / 2 - Bumb.TYPE4.height / 2);
            } else if (this.bumbedTime == 10) {
                Bumb.generate(Bumb.TYPE4, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - Bumb.TYPE4.height / 2);
            } else if (this.bumbedTime < 20) {
                this.setFrame(2);
            } else if (this.bumbedTime >= 20 && this.bumbedTime < 40) {
                this.setFrame(3);
            } else if (this.bumbedTime >= 40 && this.bumbedTime < 60) {
                this.setFrame(4);
            } else if (this.bumbedTime >= 60 && this.bumbedTime < 80) {
                this.setFrame(5);
            } else {
                Main.sucess();
            }
            return;
        }
        if (this.hitted) {
            this.setFrame(1);
            ++this.hitPeriod;
            if (this.hitPeriod > 2) {
                this.hitted = false;
                this.hitPeriod = 0;
            }
            return;
        }
        this.setFrame(0);
        this.move();
        if (!this.started) {
            if (this.getY() >= 30) {
                this.direction = 0;
                this.started = true;
            }
            return;
        }
        if (this.getX() <= 0) {
            this.changeDir();
        } else if (this.getX() + this.getWidth() >= ViewPort.WIDTH) {
            this.changeDir();
        }
        if (++notShot >= maxNotshot) {
            notShot = 0;
            if (Main.game instanceof Level3) {
                if (this.health > 80) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE7, 1, 12);
                } else if (this.health > 50) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE5, 1, 12);
                } else {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE9, 1, 12);
                }
            } else if (Main.game instanceof Level2) {
                if (this.health > 80) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE17, 1, 12);
                } else if (this.health > 50) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE16, 1, 12);
                } else {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE12, 1, 12);
                }
            } else if (Main.game instanceof Game) {
                if (this.health > 80) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE2, 1, 12);
                } else if (this.health > 50) {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE3, 1, 12);
                } else {
                    Ammo.generate(this.getX() + Hero.rndXAmmo(), this.getY() + this.getHeight() / 2, Ammo.TYPE4, 1, 12);
                }
            }
        }
    }

    public void changeDir() {
        this.direction = this.direction == 0 ? 8 : 0;
    }

    public void hit(Ammo ammo) {
        this.hitted = true;
        this.health -= ammo.type.healthEffect;
        Bumb.generateOnCondition(Bumb.TYPE1, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE1.width) / 2, this.getY());
        EnemyHealth.addHealthObject(this.ID, 50, 100, this.health, 5, 10);
        if (this.health <= 0) {
            Game.removeElement(this);
            Bumb.generate(Bumb.TYPE4, this.getX() + Math.abs(this.getWidth() - Bumb.TYPE4.width) / 2, this.getY() + this.getHeight() / 2 - Bumb.TYPE4.height / 2);
            ++this.bumbedTime;
        }
    }

    static {
        maxNotshot = 10;
        notShot = 0;
    }
}

