/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.ResourceLoader;
import game.Setting;
import game.Splash;
import game.Tasks;
import game.ViewPort;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import level2.Level2;
import level3.Level3;
import level4.Level4;
import menu.Menu;

public class Main
extends MIDlet {
    public static Display display;
    static Main main;
    static Random rnd;
    public static Game game;
    private static float[] sinArray;

    public static boolean testForSupported(int width, int height) {
        return width <= height;
    }

    public void startApp() {
        main = this;
        display = Display.getDisplay((MIDlet)this);
        Main.initializeSinArray();
        ViewPort.setViewPort();
        ResourceLoader.intialize();
        Setting.Read();
        Splash.startViewing(new String[]{"/splashes/logo.jpg", "/splashes/s1.jpg"}, Tasks.LoadMenu());
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unConditional) {
    }

    public static void viewLevel1(int gameTime, int playerHealth, int weaponBonusValue, int savedEnemy) {
        game = new Game();
        game.load(gameTime, playerHealth, weaponBonusValue, savedEnemy);
    }

    public static void viewLevel2(int gameTime, int playerHealth, int weaponBonusValue, int savedEnemy) {
        game = new Level2();
        game.load(gameTime, playerHealth, weaponBonusValue, savedEnemy);
    }

    public static void viewLevel3(int gameTime, int playerHealth, int weaponBonusValue, int savedEnemy) {
        game = new Level3();
        game.load(gameTime, playerHealth, weaponBonusValue, savedEnemy);
    }

    public static void viewLevel4(int gameTime, int playerHealth, int weaponBonusValue, int savedEnemy) {
        game = new Level4();
        game.load(gameTime, playerHealth, weaponBonusValue, savedEnemy);
    }

    public static void continueCurrentLevel() {
        game.restart();
        Main.setCurrent((Displayable)game);
    }

    public static void stopLoadMenu() {
        game.stopAndViewMainMenu();
    }

    public static void gameOver() {
        game.gameOver();
    }

    public static void sucess() {
        game.sucess();
    }

    public static void cleanCurrentLevel() {
        game.clean();
    }

    public void viewMenu() {
        Menu.load();
    }

    public static void downloadFullVersion() {
        String url = null;
        url = null;
        try {
            main.platformRequest(url);
        }
        catch (Exception ex) {
            Form form = new Form("Space Fighter");
            form.append((Item)new StringItem("you can dwonload from", url));
            Command cmd = new Command("Exit", 7, 0);
            form.addCommand(cmd);
            form.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    main.notifyDestroyed();
                }
            });
            Main.setCurrent((Displayable)form);
            return;
        }
        main.notifyDestroyed();
    }

    public static void setCurrent(Displayable next) {
        display.setCurrent(next);
    }

    public static boolean isForeground() {
        Displayable displayable = null;
        try {
            displayable = display.getCurrent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (displayable == null) {
            return false;
        }
        return displayable.isShown();
    }

    public static Displayable getCurrent() {
        return display.getCurrent();
    }

    public static int random(int n) {
        int r = rnd.nextInt() % (n + 1);
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static int randomMinus(int n) {
        int r = rnd.nextInt() % (n + 1);
        return r;
    }

    private static void initializeSinArray() {
        Main.sinArray[0] = (float)Math.sin(Math.toRadians(0.0));
        Main.sinArray[1] = (float)Math.sin(Math.toRadians(22.5));
        Main.sinArray[2] = (float)Math.sin(Math.toRadians(45.0));
        Main.sinArray[3] = (float)Math.sin(Math.toRadians(67.5));
        Main.sinArray[4] = (float)Math.sin(Math.toRadians(90.0));
        Main.sinArray[5] = (float)Math.sin(Math.toRadians(112.5));
        Main.sinArray[6] = (float)Math.sin(Math.toRadians(135.0));
        Main.sinArray[7] = (float)Math.sin(Math.toRadians(157.5));
        Main.sinArray[8] = (float)Math.sin(Math.toRadians(180.0));
        Main.sinArray[9] = (float)Math.sin(Math.toRadians(202.5));
        Main.sinArray[10] = (float)Math.sin(Math.toRadians(225.0));
        Main.sinArray[11] = (float)Math.sin(Math.toRadians(247.5));
        Main.sinArray[12] = (float)Math.sin(Math.toRadians(270.0));
        Main.sinArray[13] = (float)Math.sin(Math.toRadians(292.5));
        Main.sinArray[14] = (float)Math.sin(Math.toRadians(315.0));
        Main.sinArray[15] = (float)Math.sin(Math.toRadians(337.5));
        Main.sinArray[16] = (float)Math.sin(Math.toRadians(360.0));
        for (int j = 0; j < sinArray.length; ++j) {
            System.out.println(sinArray[j]);
        }
    }

    public static double sin(double value) {
        if (value % 22.5 > 0.0) {
            return -1000.0;
        }
        return sinArray[(int)(value / 22.5)];
    }

    static {
        rnd = new Random();
        sinArray = new float[17];
    }
}

