/*
 * Decompiled with CFR 0.152.
 */
package groups;

import game.Game;
import groups.GroupBehavior;
import groups.GroupCircle;
import groups.GroupFour;
import groups.GroupPyramid;
import groups.GroupSeven;
import groups.GroupThree;
import groups.SmallEnemy;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Group {
    public static boolean canGenerate = true;
    static final int TYPE_PYRAMID = 0;
    static final int TYPE_CIRCLE = 1;
    static final int TYPE_THREE = 2;
    static final int TYPE_FOUR = 3;
    static final int TYPE_SEVEN = 4;
    static Image[] arrImages;
    static Random rndImgs;
    static Random rndTypes;
    static Group currentGroup;
    Image img;
    Vector vecEnemies;
    boolean allTookPlaces;
    Random rndAmmo = new Random();
    int IDAmmo;
    int notShotPeriod;
    int maxNotShot;
    GroupBehavior behavior = null;
    boolean startedBehavior = false;

    public static void loadLevel1() {
        arrImages = new Image[3];
        rndImgs = new Random();
        rndTypes = new Random();
        try {
            Group.arrImages[0] = Image.createImage((String)"/enemy1.png");
            Group.arrImages[1] = Image.createImage((String)"/enemy2.png");
            Group.arrImages[2] = Image.createImage((String)"/enemy3.png");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void loadLevel2() {
        arrImages = new Image[3];
        rndImgs = new Random();
        rndTypes = new Random();
        try {
            Group.arrImages[0] = Image.createImage((String)"/level2/enemy1.png");
            Group.arrImages[1] = Image.createImage((String)"/level2/enemy2.png");
            Group.arrImages[2] = Image.createImage((String)"/level2/enemy3.png");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void loadLevel3() {
        arrImages = new Image[3];
        rndImgs = new Random();
        rndTypes = new Random();
        try {
            Group.arrImages[0] = Image.createImage((String)"/level3/plane-1.png");
            Group.arrImages[1] = Image.createImage((String)"/level3/plane-1.png");
            Group.arrImages[2] = Image.createImage((String)"/level3/plane-1.png");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void clean() {
        arrImages = null;
        rndImgs = null;
        rndTypes = null;
        currentGroup = null;
    }

    public static void generate() {
        if (!canGenerate) {
            return;
        }
        int type = Group.randomType();
        Image img = Group.randomImage();
        switch (type) {
            case 2: {
                currentGroup = new GroupThree(img);
                break;
            }
            case 1: {
                currentGroup = new GroupCircle(img);
                break;
            }
            case 0: {
                currentGroup = new GroupPyramid(img);
                break;
            }
            case 4: {
                currentGroup = new GroupSeven(img);
                break;
            }
            case 3: {
                currentGroup = new GroupFour(img);
            }
        }
        canGenerate = false;
    }

    public static void cycleAll() {
        if (currentGroup != null) {
            currentGroup.cycle();
        }
    }

    public static void drawAll(Graphics g) {
        if (currentGroup != null) {
            currentGroup.draw(g);
        }
    }

    public static Image randomImage() {
        int r = rndImgs.nextInt() % 3;
        if (r < 0) {
            r *= -1;
        }
        return arrImages[r];
    }

    public static int randomType() {
        int r = rndTypes.nextInt() % 5;
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public void cycle() {
        for (int j = 0; j < this.vecEnemies.size(); ++j) {
            ((SmallEnemy)this.vecEnemies.elementAt(j)).cycle();
        }
        if (!this.allTookPlaces) {
            boolean allArrived = true;
            for (int j = 0; j < this.vecEnemies.size(); ++j) {
                if (((SmallEnemy)this.vecEnemies.elementAt((int)j)).arrivedPlannedPlace) continue;
                allArrived = false;
                break;
            }
            if (allArrived) {
                this.allTookPlaces = true;
            }
        } else if (this.allTookPlaces) {
            this.setDirections(this.behavior.getDirection());
        }
        if (this.notShotPeriod >= this.maxNotShot) {
            this.IDAmmo = this.randomAmmo();
            this.notShotPeriod = 0;
        } else {
            this.IDAmmo = -1;
            ++this.notShotPeriod;
        }
    }

    public void draw(Graphics g) {
        for (int j = 0; j < this.vecEnemies.size(); ++j) {
            ((SmallEnemy)this.vecEnemies.elementAt(j)).draw(g);
        }
    }

    public int randomAmmo() {
        if (this.vecEnemies.size() == 0) {
            return -1;
        }
        int r = rndImgs.nextInt() % this.vecEnemies.size();
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public void removeEnemy(SmallEnemy enemy) {
        this.vecEnemies.removeElement(enemy);
        Game.removeElement(enemy);
        if (this.vecEnemies.size() == 0) {
            canGenerate = true;
            currentGroup = null;
            this.behavior.reIntialize();
            System.gc();
        }
    }

    public void setDirections(int dir) {
        this.startedBehavior = true;
        for (int j = 0; j < this.vecEnemies.size(); ++j) {
            ((SmallEnemy)this.vecEnemies.elementAt((int)j)).direction = dir;
        }
    }
}

