/*
 * Decompiled with CFR 0.152.
 */
package layers;

import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import layers.Layer0;
import layers.Layer1;
import layers.Layer2;
import layers.Layer3;
import layers.Layer4;
import layers.Layer5;
import layers.Layer6;
import layers.Layer7;

public abstract class SKLayer
extends TiledLayer {
    public static boolean canGenerate = true;
    public static int SQUARE_WIDTH = 30;
    public static int SQUARE_HEIGHT = 30;
    static int[][] map;
    static Vector vectorLayers;
    private static Random rndLayer;
    private static final int layer0 = 0;
    private static final int layer1 = 1;
    private static final int layer2 = 2;
    private static final int layer3 = 3;
    private static final int layer4 = 4;
    private static final int layer5 = 5;
    private static final int layer6 = 6;
    private static final int layer7 = 7;
    private static int layerNumb;
    int sp = 3;
    int direction = 12;
    boolean raisedGenerate = false;
    int x;
    int y;

    public static void create() {
        vectorLayers = new Vector();
        map = new int[4][6];
        rndLayer = new Random();
        SQUARE_WIDTH = 40;
        SQUARE_HEIGHT = 40;
    }

    private static int rndLayer() {
        int r = rndLayer.nextInt() % 8;
        if (r < 0) {
            r *= -1;
        }
        return r;
    }

    public static void generate() {
        if (!canGenerate) {
            return;
        }
        layerNumb = SKLayer.rndLayer();
        switch (layerNumb) {
            case 0: {
                Layer0.generate();
                break;
            }
            case 1: {
                Layer1.generate();
                break;
            }
            case 2: {
                Layer2.generate();
                break;
            }
            case 3: {
                Layer3.generate();
                break;
            }
            case 4: {
                Layer4.generate();
                break;
            }
            case 5: {
                Layer5.generate();
                break;
            }
            case 6: {
                Layer6.generate();
                break;
            }
            case 7: {
                Layer7.generate();
            }
        }
        canGenerate = false;
    }

    public static void drawAll(Graphics g) {
        for (int j = 0; j < vectorLayers.size(); ++j) {
            ((SKLayer)((Object)vectorLayers.elementAt(j))).draw(g);
        }
    }

    public static void cycleAll() {
        for (int j = vectorLayers.size() - 1; j >= 0; --j) {
            ((SKLayer)((Object)vectorLayers.elementAt(j))).cycle();
        }
    }

    public SKLayer(int colums, int rows, Image img, int tileWidth, int tileHeight) {
        super(colums, rows, img, tileWidth, tileHeight);
        this.setLayer();
        this.generateFanEnemies();
    }

    public abstract void setLayer();

    public abstract void generateFanEnemies();

    public void draw(Graphics g) {
        this.paint(g);
    }

    public void cycle() {
        this.y += this.sp;
        this.setPosition(this.x, this.y);
        if (this.y >= 0 && !this.raisedGenerate) {
            canGenerate = true;
            this.raisedGenerate = true;
        }
        if (this.y > ViewPort.HEIGHT) {
            vectorLayers.removeElement((Object)this);
            System.gc();
        }
    }

    static {
        layerNumb = -1;
    }
}

