/*
 * Decompiled with CFR 0.152.
 */
package level3;

import game.Main;
import game.ViewPort;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.TiledLayer;
import level3.Level3;

public class SquaresLayer {
    private static Vector vecLayers;
    private static int sp;
    private static int[] indexes;

    public static void create() {
        vecLayers = new Vector();
    }

    public static void clean() {
        vecLayers = null;
    }

    public static void draw(Graphics g) {
        TiledLayer temp = null;
        for (int j = 0; j < vecLayers.size(); ++j) {
            temp = (TiledLayer)vecLayers.elementAt(j);
            temp.paint(g);
        }
    }

    public static void cycle() {
        TiledLayer temp = null;
        for (int j = vecLayers.size() - 1; j >= 0; --j) {
            temp = (TiledLayer)vecLayers.elementAt(j);
            temp.setPosition(temp.getX(), temp.getY() + sp);
            if (temp.getY() <= ViewPort.HEIGHT) continue;
            vecLayers.removeElement(temp);
        }
        try {
            temp = (TiledLayer)vecLayers.lastElement();
        }
        catch (NoSuchElementException noe) {
            SquaresLayer.addLayer();
            return;
        }
        if (temp.getY() > 0) {
            SquaresLayer.addLayer();
        }
    }

    private static void addLayer() {
        TiledLayer temp = SquaresLayer.getNewLayer();
        temp.setPosition(ViewPort.WIDTH / 2 - temp.getWidth() / 2, -temp.getHeight());
        vecLayers.addElement(temp);
    }

    private static TiledLayer getNewLayer() {
        int[][] map = new int[12][15];
        TiledLayer temp = new TiledLayer(12, 15, Level3.imgSquare, Level3.imgSquare.getWidth(), Level3.imgSquare.getHeight());
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 15; ++i) {
                temp.setCell(j, i, SquaresLayer.getRandomIndex());
            }
        }
        return temp;
    }

    private static int getRandomIndex() {
        int index = indexes[Main.random(indexes.length - 1)];
        return index;
    }

    static {
        sp = 2;
        indexes = new int[]{0, 1, 0};
    }
}

