/*
 * Decompiled with CFR 0.152.
 */
package level3;

import game.Main;
import game.ViewPort;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import layers.FanEnemy;
import level3.Alarm;
import level3.Level3;

public class WireObject {
    private int sp;
    private int y;
    int height;
    int width;
    private Vector vecSprites;
    private Vector vecAlarms;
    int xPlus;

    public WireObject(int startY, int sp) {
        this.sp = sp;
        this.vecSprites = new Vector();
        int any = Main.random(2);
        if (any == 1) {
            this.xPlus = 30;
        } else if (any == 2) {
            this.xPlus = -30;
        }
        Sprite temp = new Sprite(Level3.imgWire2);
        this.height = temp.getHeight();
        temp.setPosition(ViewPort.WIDTH / 4 + this.xPlus, startY - this.height);
        this.vecSprites.addElement(temp);
        temp = new Sprite(Level3.imgWire2);
        temp.setPosition(ViewPort.WIDTH / 4 * 3 + this.xPlus, startY - this.height);
        this.vecSprites.addElement(temp);
        if (Main.random(1) == 0) {
            this.addHorizontalsprites(startY);
        }
        this.height += temp.getHeight();
        temp = new Sprite(Level3.imgWire2);
        temp.setPosition(ViewPort.WIDTH / 4 + this.xPlus, startY - this.height);
        this.vecSprites.addElement(temp);
        temp = new Sprite(Level3.imgWire2);
        temp.setPosition(ViewPort.WIDTH / 4 * 3 + this.xPlus, startY - this.height);
        this.vecSprites.addElement(temp);
        this.addHorizontalsprites(startY);
        int rnd = Main.random(4);
        if ((rnd != 3 || Level3.WireLayerEnemiesLevel == 2) && Level3.WireLayerEnemiesLevel != 0) {
            this.addAlarms(startY);
            this.addEnemies(startY);
        }
        this.y = startY - this.height;
    }

    private void addHorizontalsprites(int startY) {
        int rnd = Main.random(1);
        Image img = null;
        img = rnd == 0 ? Level3.imgWire3 : Level3.imgWire1;
        int n = ViewPort.WIDTH / img.getWidth() + 1;
        Sprite temp = null;
        for (int j = 0; j < n; ++j) {
            temp = new Sprite(img);
            temp.setPosition(j * temp.getWidth(), startY - this.height);
            this.vecSprites.addElement(temp);
        }
    }

    private void addAlarms(int startY) {
        this.vecAlarms = new Vector();
        Alarm alarm = new Alarm(Level3.imgAlarm, 3, 1, this.sp);
        alarm.setPosition(ViewPort.WIDTH / 4 + this.xPlus - 2, startY - this.height / 2);
        this.vecAlarms.addElement(alarm);
        alarm = new Alarm(Level3.imgAlarm, 3, 1, this.sp);
        alarm.setPosition(ViewPort.WIDTH / 4 * 3 - 2 + this.xPlus, startY - this.height / 2);
        this.vecAlarms.addElement(alarm);
    }

    private void addEnemies(int startY) {
        FanEnemy.generate(ViewPort.WIDTH / 4 + this.xPlus - 10, startY - this.height - 10, this.sp, (byte)3);
        FanEnemy.generate(ViewPort.WIDTH / 4 * 3 - 10 + this.xPlus, startY - this.height - 10, this.sp, (byte)3);
    }

    public void draw(Graphics g) {
        int j;
        Sprite temp = null;
        for (j = this.vecSprites.size() - 1; j >= 0; --j) {
            temp = (Sprite)this.vecSprites.elementAt(j);
            temp.paint(g);
        }
        if (this.vecAlarms != null) {
            for (j = this.vecAlarms.size() - 1; j >= 0; --j) {
                temp = (Sprite)this.vecAlarms.elementAt(j);
                temp.paint(g);
            }
        }
    }

    public void cycle() {
        Sprite temp = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            temp = (Sprite)this.vecSprites.elementAt(j);
            temp.setPosition(temp.getX(), temp.getY() + this.sp);
        }
        temp = (Sprite)this.vecSprites.lastElement();
        this.y = temp.getY();
        if (this.vecAlarms != null) {
            Alarm alarm = null;
            for (int j = this.vecAlarms.size() - 1; j >= 0; --j) {
                alarm = (Alarm)((Object)this.vecAlarms.elementAt(j));
                alarm.cycle();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getY() {
        return this.y;
    }

    public void setSP(int sp) {
        this.sp = sp;
    }
}

