/*
 * Decompiled with CFR 0.152.
 */
package level3.enemieammo;

import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level3.enemieammo.EnemyAmmo;

public class EnemyAmmoController {
    private Vector vecEnemies = new Vector();
    private Image image;
    private int width;
    private int height;
    private Random random = new Random();
    private boolean canGenerate = true;
    private boolean testedLastEnemy;

    public EnemyAmmoController(Image image, int width, int height) {
        this.image = image;
        this.width = width;
        this.height = height;
    }

    public void cycle() {
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
            return;
        }
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((EnemyAmmo)this.vecEnemies.elementAt(j)).cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            EnemyAmmo enemyAmmo = (EnemyAmmo)this.vecEnemies.lastElement();
            if (enemyAmmo.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            ((EnemyAmmo)this.vecEnemies.elementAt(j)).paint(g);
        }
    }

    public void generate() {
        if (!this.canGenerate) {
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        EnemyAmmo enemyAmmo = new EnemyAmmo(this.image, this.width, this.height, this);
        this.vecEnemies.addElement(enemyAmmo);
        Game.addElement(enemyAmmo);
        enemyAmmo.setPosition(ViewPort.WIDTH / 2 - enemyAmmo.getWidth() / 2, -enemyAmmo.getHeight());
    }

    public void removeEnemy(EnemyAmmo enemy) {
        this.vecEnemies.removeElement(enemy);
        Game.removeElement(enemy);
    }
}

