/*
 * Decompiled with CFR 0.152.
 */
package level3.laser;

import game.ExpandedSprite;
import game.Game;
import javax.microedition.lcdui.Image;
import level3.laser.LaserEnemy;

public class LaserEnemyDown
extends LaserEnemy {
    public LaserEnemyDown(Image image, int width, int height, int frameIndex, Image imgLaser, int laserWidth, int laserHeight) {
        super(image, width, height, frameIndex);
        this.setLaserFrames(imgLaser, laserWidth, laserHeight);
    }

    private void setLaserFrames(Image imgLaser, int laserWidth, int laserHeight) {
        int columns = imgLaser.getWidth() / laserWidth;
        int rows = imgLaser.getHeight() / laserHeight;
        this.laserFrames = new Image[rows * columns];
        int count = 0;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < columns; ++i) {
                this.laserFrames[count] = Image.createImage((Image)imgLaser, (int)(i * laserWidth), (int)(j * laserHeight), (int)laserWidth, (int)laserHeight, (int)0);
                ++count;
            }
        }
    }

    public void cycle() {
        if (this.spriteLaser == null && this.getY() > 0) {
            this.generateLaser();
        } else if (this.spriteLaser != null) {
            this.cycleLaser();
        }
        this.move();
        if (this.exitedView()) {
            this.remove();
        }
    }

    protected void generateLaser() {
        this.spriteLaser = new ExpandedSprite(this.laserFrames[0], 0, 1);
        this.hittedPlayer = false;
        this.spriteLaser.setMinimumHeight();
        this.spriteLaser.setPosition(this.getX() + this.getWidth() / 2 - this.spriteLaser.getWidth() / 2, this.getY() + this.getHeight() - 10);
    }

    protected void cycleLaser() {
        if (!this.hittedPlayer && this.spriteLaser.collidesWith(Game.player, true)) {
            Game.player.hit(10);
            this.hittedPlayer = true;
            this.laserIncreasing = false;
        }
        if (this.laserIncreasing) {
            this.spriteLaser.increaseHight(10);
            if (this.spriteLaser.reachedMaxHeight()) {
                this.nextLaserFrame();
            }
        } else {
            this.spriteLaser.decreaseHeight(10);
            this.spriteLaser.setPosition(this.spriteLaser.getX(), this.spriteLaser.getY() + 10);
            if (this.spriteLaser.reachedMinHeight()) {
                this.spriteLaser = null;
                this.laserIncreasing = true;
            }
        }
    }
}

