/*
 * Decompiled with CFR 0.152.
 */
package mathEngine;

import game.ViewPort;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mathEngine.CurveEnemy;

public class RightCurveEnemy
extends CurveEnemy {
    public RightCurveEnemy(Image image, int width, int height, int x, int y, byte[] dirFrames) {
        super(image, width, height, x, y, dirFrames);
        this.sp *= 2;
    }

    public void cycle() {
        if (this.y < this.curveStart) {
            this.setLastXY();
            this.y += this.sp;
            this.setPosition(this.x, this.y);
            return;
        }
        if (this.collidedPlayer()) {
            return;
        }
        if (this.lastY + this.getHeight() < 0 && this.y + this.getHeight() >= 0) {
            this.minus = this.x;
        }
        this.setPosition(this.x, this.y);
        this.setDirFrame();
        this.setLastXY();
        this.y += this.sp;
        this.curveAngle += this.sp / this.step;
        this.calculate();
    }

    protected void setDirFrame() {
        if (this.curveAngle < 60) {
            this.setFrame(this.dirFrames[10]);
        } else if (this.curveAngle >= 60 && this.curveAngle < 120) {
            this.setFrame(this.dirFrames[12]);
        } else {
            this.setFrame(this.dirFrames[14]);
        }
    }

    public void draw(Graphics g) {
        this.paint(g);
    }

    protected void initialize() {
        this.x = ViewPort.WIDTH;
        this.step = ViewPort.getCurveStep(ViewPort.HEIGHT);
        this.curveStart = ViewPort.getCurveStart(ViewPort.HEIGHT, this.step);
        this.curveAngle = 0;
    }

    private void setLastXY() {
        this.lastX = this.x;
        this.lastY = this.y;
    }

    protected void calculate() {
        double sinY = Math.sin(Math.toRadians(this.curveAngle));
        this.x = ViewPort.WIDTH - (int)(sinY * (double)ViewPort.WIDTH / 2.0);
    }

    public boolean outOfView() {
        return this.y >= ViewPort.HEIGHT;
    }
}

