/*
 * Decompiled with CFR 0.152.
 */
package com.alienfactory.javamappy.viewer;

import com.alienfactory.javamappy.MapHeader;
import com.alienfactory.javamappy.util.ParameterChecker;
import com.alienfactory.javamappy.viewer.render.Renderer;

public abstract class Viewer {
    protected final MapHeader a;
    protected final Renderer b;
    protected int c;
    protected int d;
    protected int e;
    protected int f;
    protected int g;
    protected int h;
    protected boolean i;

    public Viewer(MapHeader mapHeader, Renderer renderer, int n, int n2, int n3, int n4) {
        ParameterChecker.checkNotNull(mapHeader, "mapHeader");
        ParameterChecker.checkNotNull(renderer, "renderer");
        this.a = mapHeader;
        this.b = renderer;
        this.setViewWidth(n);
        this.setViewHeight(n2);
        this.setViewOffsetX(n3);
        this.setViewOffsetY(n4);
        this.i = mapHeader.isRisingPillarMode();
    }

    public int getViewWidth() {
        return this.c;
    }

    public void setViewWidth(int n) {
        ParameterChecker.checkMinMax(n, "viewWidth", 1, this.a.getMapPixelWidth());
        this.c = n;
    }

    public int getViewHeight() {
        return this.d;
    }

    public void setViewHeight(int n) {
        ParameterChecker.checkMinMax(n, "viewHeight", 1, this.a.getMapPixelHeight());
        this.d = n;
    }

    public int getViewOffsetX() {
        return this.e;
    }

    public void setViewOffsetX(int n) {
        ParameterChecker.checkMin(n, "viewOffsetX", 0);
        this.e = n;
    }

    public int getViewOffsetY() {
        return this.f;
    }

    public void setViewOffsetY(int n) {
        ParameterChecker.checkMin(n, "viewOffsetY", 0);
        this.f = n;
    }

    public Renderer getRenderer() {
        return this.b;
    }

    public MapHeader getMapHeader() {
        return this.a;
    }

    public boolean isPillarRiserMode() {
        return this.i;
    }

    public void setPillarRiserMode(boolean bl) {
        this.i = bl;
    }

    public int getPixelX() {
        return this.g;
    }

    public void setPixelX(int n) {
        ParameterChecker.checkMinMax(n, "pixelX", 0, this.a.getMapPixelWidth() - this.c);
        this.g = n;
    }

    public void addPixelX(int n) {
        this.g += n;
    }

    public int getPixelY() {
        return this.h;
    }

    public void setPixelY(int n) {
        ParameterChecker.checkMinMax(n, "pixelY", 0, this.a.getMapPixelHeight() - this.d);
        this.h = n;
    }

    public void addPixelY(int n) {
        this.h += n;
    }

    public int getBlockX() {
        return this.g / this.a.getBlockWidth();
    }

    public void setBlockX(int n) {
        ParameterChecker.checkMinMax(n, "blockX", 0, this.a.getMapBlockWidth() - this.c / this.a.getBlockWidth());
        this.g = n * this.a.getBlockWidth();
    }

    public void addBlockX(int n) {
        this.g += n * this.a.getBlockWidth();
    }

    public int getBlockY() {
        return this.h / this.a.getBlockHeight();
    }

    public void setBlockY(int n) {
        ParameterChecker.checkMinMax(n, "blockY", 0, this.a.getMapBlockHeight() - this.d / this.a.getBlockHeight());
        this.h = n * this.a.getBlockHeight();
    }

    public void addBlockY(int n) {
        this.h += n * this.a.getBlockHeight();
    }

    public abstract void draw(Object var1, boolean var2);

    public abstract void draw(Object var1, boolean var2, int var3, int var4, int var5, int var6);
}

