/*
 * Decompiled with CFR 0.152.
 */
package net.dclausen.microfloat;

import net.dclausen.microfloat.BitUtils;

public class MicroDouble {
    public static final long ZERO = 0L;
    public static final long NEGATIVE_ZERO = Long.MIN_VALUE;
    public static final long POSITIVE_INFINITY = 0x7FF0000000000000L;
    public static final long NEGATIVE_INFINITY = -4503599627370496L;
    public static final long NaN = 9221120237041090560L;
    public static final long MAX_VALUE = 0x7FEFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = 1L;
    public static final long LN2 = 4604418534313441775L;
    private static final long ABS_MASK = Long.MAX_VALUE;
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long FRACTION_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IMPLIED_ONE = 0x10000000000000L;
    private final long value;
    private static final long[] pow2m = new long[]{4556951262222748433L, -9114107888677362826L, 1911323890694592264L, 3914391328142524957L, 8016673440035891112L, -2028596868516046619L, 3362436547623629823L, 6886270049533193878L, -4343663012265570553L, 2888311001383727322L, 5915260930833873555L, -6332289687361778576L, 2481040258324023919L, 5081170449047600985L, -8040506994060064798L, 2131197353912214900L, 4364692180812216116L, 8938889586303418605L, -139898200960150312L, 3749242034739077387L, 7678447687145630489L, -2721283210435300375L, 3220574384798566654L, 6595736340067464508L, -4938676049251384304L, 2766452331409032665L, 5665694374725698899L, -6843401994271320271L, 2376364457868949779L, 4866794409715609148L, -8479549122611984080L, 2041281525984781831L, 4180544565216833190L, 8561755269564074374L, -912269281642327298L, 3591060437415367540L, 7354491775826672723L, -3384744916816525880L, 3084697427331691671L, 6317460331175304542L, -5508585315462527915L, 2649734913688990454L, 5426657103235052450L, -7332950326284164199L, 2276104959472719343L, 4661462957000129215L, -8900067937773286985L, 1955159272639746997L, 4004166190366201849L, 8200532357869981386L, -1652053804791829737L, 3439552567074349441L, 7044203657368267655L, -4020214983419339459L, 2954553157691435450L, 6050924866952059801L, -6054449946191733143L, 2537941837315649223L, 5197704882822449609L, -7801844473689174816L, 2180075438084173169L, 4464794497196386649L, 9143899130258199858L, 1872670541876879331L, 3835229269763848870L, 7854549544476362485L, -2360626606621961247L, 3294436857259538508L, 6747006683667534864L, -4628874385558440215L, 2829899712133347615L, 5795634610449095915L, -6577284391509803182L, 2430865342914508479L, 4978412222288913366L, -8250955842461857043L, 2088097429759527849L, 4276423536147513034L, 8758115402030106693L, -510123730351893108L, 3673419846319648462L, 7523163845262640051L, -3039304518611664792L, 3155443620884047222L, 6462348535570528710L, -5211854272861108818L, 2710505431213761085L, 5551115123125782702L, -7078060301547948642L, 2328306436538696289L, 4768371582031250000L, -8681119073709551616L, 2000000000000000000L, 4096000000000000000L, 8388608000000000000L, -1266874889709551616L, 3518437208883200000L, 0x6400000000000000L, -3689348814741910323L, 3022314549036572937L, 6189700196426901374L, -5770238071427257601L, 2596148429267413814L, 5316911983139663492L, -7557708332239520785L, 2230074519853062314L, 4567192616659071619L, -9093133594791772939L, 1915619426082361073L, 3923188584616675477L, 8034690221294951378L, -1991698500497491194L, 3369993333393829974L, 6901746346790563787L, -4311967555482476979L, 2894802230932904886L, 5928554968950589206L, -6305063497298744923L, 2486616182048933211L, 5092589940836215216L, -8017119874876982854L, 2135987035920910082L, 4374501449566023849L, 8958978968711216842L, -98755145788979523L, 3757668132438133165L, 7695704335233296721L, -2685941595151759931L, 3227812347608635737L, 6610559687902485990L, -4908317832885260309L, 2772669694120814860L, 5678427533559428832L, -6817324484979841367L, 2381705131771844659L, 4877732109868737862L, -8457148712698376476L, 2045869129935088669L, 4189939978107061594L, 8580997075163262144L, -872862063775190746L, 3599131035634557106L, 7371020360979572954L, -3350894374423386207L, 3091630018413806676L, 6331658277711476072L, -5479507920956448621L, 2655689964083835493L, 5438853046443695091L, -7307973034592864070L, 2281220308811097609L, 4671939192445127904L, -8878612607581929669L, 1959553324262936975L, 4013165208090494924L, 8218962346169333605L, -1614309188754756393L, 3447282664438742062L, 7060034896770543742L, -3987792605123478032L, 2961193260766427870L, 6064523798049644278L, -6026599335303880135L, 2543645642425481519L, 5209386275687386152L, -7777920981101784777L, 2184974969366070649L, 4474828737261712688L, 9164449253911987585L, 1876879207201175057L, 3843848616348006518L, 7872201966280717348L, -2324474446766642487L, 3301840819597907790L, 6762169998536515153L, -4597819916706768582L, 2836259667354169965L, 5808659798741340089L, -6550608805887287114L, 2436328502849999770L, 4989600773836799529L, -8228041688891786180L, 2092790248410678361L, 4286034428745069284L, 8777798510069901893L, -469812725086392539L, 3681675540198022979L};
    private static final short[] pow2x = new short[]{-323, -320, -316, -313, -310, -307, -303, -300, -297, -293, -290, -287, -283, -280, -277, -273, -270, -267, -264, -260, -257, -254, -250, -247, -244, -240, -237, -234, -230, -227, -224, -220, -217, -214, -211, -207, -204, -201, -197, -194, -191, -187, -184, -181, -177, -174, -171, -167, -164, -161, -158, -154, -151, -148, -144, -141, -138, -134, -131, -128, -124, -121, -118, -114, -111, -108, -105, -101, -98, -95, -91, -88, -85, -81, -78, -75, -71, -68, -65, -62, -58, -55, -52, -48, -45, -42, -38, -35, -32, -28, -25, -22, -18, -15, -12, -9, -5, -2, 1, 5, 8, 11, 15, 18, 21, 25, 28, 31, 35, 38, 41, 44, 48, 51, 54, 58, 61, 64, 68, 71, 74, 78, 81, 84, 87, 91, 94, 97, 101, 104, 107, 111, 114, 117, 121, 124, 127, 131, 134, 137, 140, 144, 147, 150, 154, 157, 160, 164, 167, 170, 174, 177, 180, 184, 187, 190, 193, 197, 200, 203, 207, 210, 213, 217, 220, 223, 227, 230, 233, 237, 240, 243, 246, 250, 253, 256, 260, 263, 266, 270, 273, 276, 280, 283, 286, 289, 293};
    private static final long[] pow10m = new long[]{-815021110370542983L, -1228264617323800998L, -1631822729582842028L, -2025922448585811784L, -2410785455424649436L, -2786628235540701831L, -3153662200497784248L, -3512093806901185046L, -3862124672529506137L, -4203951689744663453L, -4537767136243840519L, -4863758783215693123L, -5182110000961642932L, -5492999862041672041L, -5796603242002637969L, -6093090917745768758L, -6382629663588669918L, -6665382345075878083L, -6941508010590729807L, -7211161980820077193L, -7474495936122174249L, -7731658001846878407L, -7982792831656159810L, -8228041688891786180L, -8467542526035952558L, -8701430062309552536L, -8929835859451740014L, -9152888395723407474L, -294682202642863838L, -720121152745989333L, -1135588877456072824L, -1541319077368263733L, -1937539975720012667L, -2324474446766642487L, -2702340141148116919L, -3071349608317525545L, -3431710416100151156L, -3783625267450371479L, -4127292114472071014L, -4462904269766699465L, -4790650515171610063L, -5110715207949843068L, -5423278384491086237L, -5728515861582144019L, -6026599335303880135L, -6317696477610263060L, -6601971030643840136L, -6879582898840692748L, -7150688238876681628L, -7415439547505577019L, -7673985747338482673L, -7926472270612804602L, -8173041140997884610L, -8413831053483314305L, -8648977452394866742L, -8878612607581929669L, -9102865688819295808L, -196981603220770741L, -624710411122851543L, -1042414325089727326L, -1450328303573004458L, -1848681798185579782L, -2237698882768172872L, -2617598379430861436L, -2988593981640518237L, -3350894374423386207L, -3704703351750405709L, -4050219931171323191L, -4387638465762062920L, -4717148753448332186L, -5038936143766954516L, -5353181642124984136L, -5660062011615247436L, -5959749872445582690L, -6252413799037706962L, -6538218414850328321L, -6817324484979841367L, -7089889006590693951L, -7356065297226292178L, -7616003081050118571L, -7869848573065574033L, -8117744561361917257L, -8359830487432564938L, -8596242524610931813L, -8827113654667930715L, -9052573742614218704L, -98755145788979523L, -528786136287117932L, -948738275445456221L, -1358847786342270957L, -1759345355577441597L, -2150456263033662926L, -2532400508596379067L, -2905392935903719049L, -3269643353196043249L, -3625356651333078602L, -3972732919045027188L, -4311967555482476979L, -4643251380128424041L, -4966770740134231719L, -5282707615139903279L, -5591239719637629412L, -5892540602936190088L, -6186779746782440749L, -6474122660694794910L, -6754730975062328270L, -7028762532061872568L, -7296371474444240045L, -7557708332239520785L, -7812920107430224633L, -8062150356639896359L, -8305539271883716404L, -8543223759426509417L, -8775337516792518218L, -9002011107970261189L, Long.MIN_VALUE, -432345564227567616L, -854558029293551616L, -1266874889709551616L, -1669528073709551616L, -2062744073709551616L, -2446744073709551616L, -2821744073709551616L, -3187955011209551616L, -3545582879861895366L, -3894828845342699809L, -4235889358507547899L, -4568956265895094861L, -4894216917640746191L, -5211854272861108818L, -5522047002568494196L, -5824969590173362729L, -6120792429631242156L, -6409681921289327534L, -6691800565486676536L, -6967307053960650171L, -7236356359111015049L, -7499099821171918249L, -7755685233340769031L, -8006256924911912373L, -8250955842461857043L, -8489919629131724885L, -8723282702051517699L, -8951176327949752869L, -9173728696990998152L, -335385916056126881L, -759870872876129023L, -1174406963520662365L, -1579227364540714457L, -1974559787411859078L, -2360626606621961247L, -2737644984756826646L, -3105826994654156138L, -3465379738694516969L, -3816505465296431844L, -4159401682681114338L, -4494261269970843337L, -4821272585683469312L, -5140619573684080616L, -5452481866653427593L, -5757034887131305500L, -6054449946191733143L, -6344894339805432013L, -6628531442943809817L, -6905520801477381890L, -7176018221920323368L, -7440175859071633405L, -7698142301602209613L, -7950062655635975441L, -8196078626372074883L, -8436328597794046994L, -8670947710510816633L, -8900067937773286985L, -9123818159709293187L, -237904397927796872L, -664674077828931748L, -1081441343357383777L, -1488440626100012710L, -1885900863153361278L, -2274045625900771989L, -2653093245771290262L, -3023256937051093262L, -3384744916816525880L, -3737760522056206171L, -4082502324048081455L, -4419164240055772162L, -4747935642407032618L, -5069001465015685407L, -5382542307406947896L, -5688734536304665171L, -5987750384837592197L, -6279758049420528746L, -6564921784364802719L, -6843401994271320271L, -7115355324258153818L, -7380934748073420954L, -7640289654143017767L, -7893565929601608404L, -8140906042354138323L, -8382449121214030822L, -8618331034163144591L, -8848684464777513505L, -9073638986861858148L, -139898200960150312L, -568964901102714405L, -987975350460687152L, -1397165242411832413L, -1796764746270372707L, -2186998636757228463L, -2568086420435798537L, -2940242459184402124L, -3303676090774835316L, -3658591746624867729L, -4005189066790915007L, -4343663012265570553L, -4674203974643163859L, -4996997883215032322L, -5312226309554747618L, -5620066569652125837L};
    private static final short[] pow10x = new short[]{-1146, -1136, -1126, -1116, -1106, -1096, -1086, -1076, -1066, -1056, -1046, -1036, -1026, -1016, -1006, -996, -986, -976, -966, -956, -946, -936, -926, -916, -906, -896, -886, -876, -867, -857, -847, -837, -827, -817, -807, -797, -787, -777, -767, -757, -747, -737, -727, -717, -707, -697, -687, -677, -667, -657, -647, -637, -627, -617, -607, -597, -587, -578, -568, -558, -548, -538, -528, -518, -508, -498, -488, -478, -468, -458, -448, -438, -428, -418, -408, -398, -388, -378, -368, -358, -348, -338, -328, -318, -308, -298, -289, -279, -269, -259, -249, -239, -229, -219, -209, -199, -189, -179, -169, -159, -149, -139, -129, -119, -109, -99, -89, -79, -69, -59, -49, -39, -29, -19, -9, 1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250, 260, 270, 280, 290, 299, 309, 319, 329, 339, 349, 359, 369, 379, 389, 399, 409, 419, 429, 439, 449, 459, 469, 479, 489, 499, 509, 519, 529, 539, 549, 559, 569, 579, 588, 598, 608, 618, 628, 638, 648, 658, 668, 678, 688, 698, 708, 718, 728, 738, 748, 758, 768, 778, 788, 798, 808, 818, 828, 838, 848, 858, 868, 877, 887, 897, 907, 917, 927, 937, 947, 957, 967, 977, 987, 997, 1007, 1017, 1027};

    static long unpackMantissa(long l) {
        if ((l & 0x7FF0000000000000L) == 0L) {
            return (l & 0xFFFFFFFFFFFFFL) << 1;
        }
        return l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
    }

    static boolean unpackSign(long l) {
        return l < 0L;
    }

    static int unpackExponent(long l) {
        return ((int)(l >> 52) & 0x7FF) - 1075;
    }

    public static boolean isNaN(long l) {
        return (l & Long.MAX_VALUE) > 0x7FF0000000000000L;
    }

    public static long negate(long l) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        return l ^ Long.MIN_VALUE;
    }

    public static boolean eq(long l, long l2) {
        return l == l2 && !MicroDouble.isNaN(l) || MicroDouble.isZero(l) && MicroDouble.isZero(l2);
    }

    public static boolean lt(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return false;
        }
        if (l2 == 0L) {
            l2 = Long.MIN_VALUE;
        }
        return MicroDouble.cmp(l, l2) < 0;
    }

    public static boolean isZero(long l) {
        return (l & Long.MAX_VALUE) == 0L;
    }

    public static long add(long l, long l2) {
        long l3;
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l);
        boolean bl2 = MicroDouble.unpackSign(l2);
        boolean bl3 = MicroDouble.isInfinite(l);
        boolean bl4 = MicroDouble.isInfinite(l2);
        if (bl3 || bl4) {
            if (bl3 && bl4) {
                if (bl != bl2) {
                    return 9221120237041090560L;
                }
                return l;
            }
            if (bl3) {
                return l;
            }
            return l2;
        }
        boolean bl5 = MicroDouble.isZero(l);
        boolean bl6 = MicroDouble.isZero(l2);
        if (bl5 || bl6) {
            if (bl5 && bl6) {
                if (bl != bl2) {
                    return 0L;
                }
                return l;
            }
            if (bl5) {
                return l2;
            }
            return l;
        }
        long l4 = MicroDouble.unpackMantissa(l) << 3;
        int n = MicroDouble.unpackExponent(l) - 3;
        long l5 = MicroDouble.unpackMantissa(l2) << 3;
        int n2 = MicroDouble.unpackExponent(l2) - 3;
        int n3 = n - n2;
        if (n3 > 0) {
            l5 = BitUtils.stickyRightShift(l5, n3);
            n2 = n;
        } else if (n3 < 0) {
            l4 = BitUtils.stickyRightShift(l4, -n3);
            n = n2;
        }
        if (bl ^ bl2) {
            if (l4 > l5) {
                l5 = -l5;
            } else {
                l4 = -l4;
                bl = bl2;
            }
        }
        if ((l3 = MicroDouble.pack(bl, n, l4 += l5)) == Long.MIN_VALUE) {
            return 0L;
        }
        return l3;
    }

    public static long sub(long l, long l2) {
        return MicroDouble.add(l, MicroDouble.negate(l2));
    }

    public static long mul(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l) ^ MicroDouble.unpackSign(l2);
        if (MicroDouble.isInfinite(l) || MicroDouble.isInfinite(l2)) {
            if (MicroDouble.isZero(l) || MicroDouble.isZero(l2)) {
                return 9221120237041090560L;
            }
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l3 = MicroDouble.unpackMantissa(l);
        int n = MicroDouble.unpackExponent(l);
        long l4 = MicroDouble.unpackMantissa(l2);
        int n2 = MicroDouble.unpackExponent(l2);
        n += n2;
        long l5 = l3 & 0xFFFFFFFL;
        long l6 = l3 >> 28;
        long l7 = l4 & 0xFFFFFFFL;
        long l8 = l4 >> 28;
        long l9 = l5 * l7;
        long l10 = l5 * l8 + l6 * l7;
        long l11 = l6 * l8;
        l11 += l10 >>> 28;
        l9 <<= 8;
        if ((l11 += (l9 += (l10 & 0xFFFFFFFL) << 28) >>> 56) == 0L) {
            return MicroDouble.pack(bl, n, l9);
        }
        int n3 = BitUtils.countLeadingZeros(l11);
        n += 56 - n3;
        l11 <<= n3;
        l11 |= l9 >>> 64 - n3;
        if (l9 << n3 != 0L) {
            l11 |= 1L;
        }
        return MicroDouble.pack(bl, n, l11);
    }

    public static long div(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l) ^ MicroDouble.unpackSign(l2);
        boolean bl2 = MicroDouble.isInfinite(l);
        boolean bl3 = MicroDouble.isInfinite(l2);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                return 9221120237041090560L;
            }
            if (bl2) {
                return bl ? -4503599627370496L : 0x7FF0000000000000L;
            }
            return bl ? Long.MIN_VALUE : 0L;
        }
        bl2 = MicroDouble.isZero(l);
        bl3 = MicroDouble.isZero(l2);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                return 9221120237041090560L;
            }
            if (bl2) {
                return bl ? Long.MIN_VALUE : 0L;
            }
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l3 = MicroDouble.unpackMantissa(l);
        int n = MicroDouble.unpackExponent(l);
        long l4 = MicroDouble.unpackMantissa(l2);
        int n2 = MicroDouble.unpackExponent(l2);
        long l5 = 0L;
        n -= n2;
        while (true) {
            int n3;
            if ((n3 = Math.min(BitUtils.countLeadingZeros(l3) - 1, BitUtils.countLeadingZeros(l5))) <= 8) {
                if (l3 == 0L) break;
                l5 |= 1L;
                break;
            }
            l5 <<= n3;
            n -= n3;
            l5 |= (l3 <<= n3) / l4;
            l3 %= l4;
        }
        return MicroDouble.pack(bl, n, l5);
    }

    public static long parseDouble(String string) {
        int n = (string = string.trim().toUpperCase()).length();
        if (n == 0) {
            throw new NumberFormatException(string);
        }
        if ("NAN".equals(string)) {
            return 9221120237041090560L;
        }
        int n2 = 0;
        boolean bl = false;
        char c = string.charAt(0);
        boolean bl2 = bl = c == '-';
        if (bl || c == '+') {
            n2 = 1;
        }
        if (n2 < n && ((c = string.charAt(n2)) == 'I' || c == 'i') && "INFINITY".equals(string.substring(n2))) {
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '.') {
                if (bl4) {
                    throw new NumberFormatException(string);
                }
                bl4 = true;
            } else {
                if (c < '0' || c > '9') break;
                ++n4;
                if (l <= 0x1999999999999998L) {
                    l = (l << 3) + (l << 1) + (long)(c - 48);
                    if (bl4) {
                        --n3;
                    }
                } else {
                    if (!bl4) {
                        ++n3;
                    }
                    bl3 |= c != '0';
                }
            }
            ++n2;
        }
        if (n4 == 0) {
            throw new NumberFormatException(string);
        }
        if (n2 + 1 < n && (string.charAt(n2) == 'E' || string.charAt(n2) == 'e')) {
            try {
                n3 += Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(string);
            }
            n2 = n;
        } else if (n2 != n) {
            throw new NumberFormatException(string);
        }
        return MicroDouble.decToDouble(bl, n3, l);
    }

    public static String toString(long l) {
        return MicroDouble.toString(l, 100);
    }

    public static long sqrt(long l) {
        if (MicroDouble.isZero(l)) {
            return l;
        }
        if (MicroDouble.unpackSign(l) || MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (l == 0x7FF0000000000000L) {
            return l;
        }
        int n = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        while (l2 < 0x10000000000000L) {
            l2 <<= 1;
            --n;
        }
        if ((n & 1) != 0) {
            l2 <<= 1;
        }
        n = (n >> 1) - 26;
        l2 <<= 1;
        long l3 = 0L;
        long l4 = 0L;
        for (long i = 0x20000000000000L; i != 0L; i >>= 1) {
            long l5 = l4 + i;
            if (l5 < l2) {
                l4 = l5 + i;
                l2 -= l5;
                l3 |= i;
            }
            l2 <<= 1;
        }
        if (l2 != 0L) {
            l3 += l3 & 1L;
        }
        return (long)n + 1075L << 52 | (l3 >>= 1) & 0xFFFFFFFFFFFFFL;
    }

    public String toString() {
        return MicroDouble.toString(this.value);
    }

    public static String toString(long l, int n) {
        if (MicroDouble.isNaN(l)) {
            return "NaN";
        }
        boolean bl = MicroDouble.unpackSign(l);
        if (MicroDouble.isZero(l)) {
            return bl ? "-0.0" : "0.0";
        }
        if (MicroDouble.isInfinite(l)) {
            return bl ? "-Infinity" : "Infinity";
        }
        if (n < 9) {
            n = 9;
        }
        int n2 = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        int n3 = n2 + 1075;
        int n4 = n3 % 11;
        l2 <<= n4;
        int n5 = pow2x[n3 /= 11];
        while (l2 <= 0xCCCCCCCCCCCCCCCL) {
            l2 = (l2 << 3) + (l2 << 1);
            --n5;
        }
        long l3 = MicroDouble.dpMul(l2, pow2m[n3]);
        boolean bl2 = false;
        while (true) {
            int n6 = (int)(l3 % 10L);
            long l4 = l3 / 10L;
            int n7 = n5 + 1;
            if (n6 != 0) {
                boolean bl3;
                if (n6 > 5 || n6 == 5 && !bl2) {
                    bl3 = true;
                    ++l4;
                } else {
                    bl3 = false;
                }
                long l5 = MicroDouble.decToDouble(bl, n7, l4);
                if (l5 != l) {
                    l4 = bl3 ? --l4 : ++l4;
                    bl3 ^= true;
                    l5 = MicroDouble.decToDouble(bl, n7, l4);
                    if (l5 != l) break;
                }
                bl2 = bl3;
            }
            l3 = l4;
            n5 = n7;
        }
        String string;
        block2: while ((string = MicroDouble.toString(bl, n5, l3)).length() > n) {
            int n8 = (int)(l3 % 10L);
            l3 /= 10L;
            ++n5;
            if (n8 > 5 || n8 == 5 && !bl2) {
                bl2 = true;
                ++l3;
            } else {
                bl2 = false;
            }
            while (true) {
                if (l3 % 10L != 0L) continue block2;
                l3 /= 10L;
                ++n5;
            }
            break;
        }
        return string;
    }

    private static String toString(boolean bl, int n, long l) {
        int n2;
        int n3;
        String string;
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(26);
        if (bl) {
            stringBuffer.append('-');
        }
        boolean bl3 = bl2 = (n += (string = Long.toString(l)).length() - 1) < -3 || n >= 7;
        if (bl2) {
            n3 = 1;
        } else {
            n3 = n + 1;
            if (n3 < 1) {
                stringBuffer.append('0');
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 < string.length()) {
                stringBuffer.append(string.charAt(n2));
                continue;
            }
            stringBuffer.append('0');
        }
        stringBuffer.append('.');
        if (n3 >= string.length()) {
            stringBuffer.append('0');
        } else {
            for (n2 = n3; n2 < string.length(); ++n2) {
                if (n2 < 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(string.charAt(n2));
            }
        }
        if (bl2) {
            stringBuffer.append('E');
            stringBuffer.append(Integer.toString(n));
        }
        return stringBuffer.toString();
    }

    private static long decToDouble(boolean bl, int n, long l) {
        if (l == 0L) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        while (l > 0L && l <= 0x1999999999999999L) {
            l = (l << 3) + (l << 1);
            --n;
        }
        if ((n /= 3) < 0) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        if (n > 218) {
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        int n2 = pow10x[n];
        int n3 = BitUtils.countLeadingZeros(l);
        n2 -= n3;
        long l2 = MicroDouble.dpMul(l <<= n3, pow10m[n]);
        for (int i = (n += 345) % 3; i > 0; --i) {
            if (l2 < 0L) {
                l2 >>>= 1;
                ++n2;
            }
            l2 += l2 >>> 2;
            n2 += 3;
        }
        return MicroDouble.pack(bl, n2, l2);
    }

    static long pack(boolean bl, int n, long l) {
        if (l != 0L) {
            int n2 = BitUtils.countLeadingZeros(l);
            l <<= n2;
            if ((n -= n2) < -1085) {
                l = BitUtils.roundingRightShift(l, -1074 - n);
            } else {
                if ((l = BitUtils.roundingRightShift(l, 11)) == 0x20000000000000L) {
                    l = 0x10000000000000L;
                    ++n;
                }
                if (n > 960) {
                    l = 0x7FF0000000000000L;
                } else {
                    l ^= 0x10000000000000L;
                    l |= (long)(n + 1086) << 52;
                }
            }
        }
        if (bl) {
            l |= Long.MIN_VALUE;
        }
        return l;
    }

    private static final long dpMul(long l, long l2) {
        long l3 = (l >>> 32) * (l2 >>> 32);
        long l4 = (l & 0xFFFFFFFFL) * (l2 >>> 32);
        long l5 = (l >>> 32) * (l2 & 0xFFFFFFFFL);
        l3 += l4 >>> 32;
        l3 += l5 >>> 32;
        if (l4 + l5 << 32 < 0L) {
            ++l3;
        }
        return l3;
    }

    public static boolean isInfinite(long l) {
        return (l & Long.MAX_VALUE) == 0x7FF0000000000000L;
    }

    private static int cmp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L) {
            if (l2 < 0L) {
                return l < l2 ? 1 : -1;
            }
            return -1;
        }
        if (l2 < 0L) {
            return 1;
        }
        return l < l2 ? -1 : 1;
    }

    public MicroDouble(long l) {
        if (MicroDouble.isNaN(l)) {
            l = 9221120237041090560L;
        }
        this.value = l;
    }

    public MicroDouble(String string) {
        this(MicroDouble.parseDouble(string));
    }

    public long doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof MicroDouble && ((MicroDouble)object).value == this.value;
    }
}

