/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import com.jarbull.mgs.game.MiniGolfProcessor;
import com.jarbull.mgs.game.ingame.Bar;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BottomBar {
    private Bar bar;
    private Image menuImage = null;
    private final Image menuText;
    private Image scoreText;
    private Image bottomCenterText;

    public BottomBar(int width) {
        try {
            this.bar = new Bar(width);
            this.menuImage = Image.createImage((String)"/res/image/ingame/menu.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (KeyCodeAdapter.getInstance().getPlatformName().equals("blackberry")) {
            this.bottomCenterText = JBManager.getInstance().getTextImage("[4] CW - [5] CCW - [SPACE] Fire", "10x10");
            this.menuText = JBManager.getInstance().getTextImage("Menu (p)", "10x10");
        } else {
            this.menuText = JBManager.getInstance().getTextImage("Menu", "10x10");
        }
        this.updateScore();
    }

    public void setPosition(int x, int y) {
        this.bar.setPosition(x, y);
    }

    public void updateScore() {
        this.scoreText = JBManager.getInstance().getTextImage("Score " + MiniGolfProcessor.getInstance().totalScore, "10x10");
    }

    public void paint(Graphics g) {
        this.bar.paint(g);
        int barCenter = this.bar.getY() + 8;
        g.drawImage(this.scoreText, 5, barCenter, 6);
        if (this.bottomCenterText != null) {
            g.drawImage(this.bottomCenterText, this.bar.getX() + this.bar.getSpecifiedWidth() / 2, barCenter, 3);
        }
        g.drawImage(this.menuImage, this.bar.getSpecifiedWidth() - this.menuText.getWidth() - 5 - 2, barCenter - 1, 10);
        g.drawImage(this.menuText, this.bar.getSpecifiedWidth() - 5, barCenter, 10);
    }
}

