/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.math;

import com.jarbull.mgs.math.MathEx;

public class Vector2D {
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(double radius, double angle, boolean inDegrees) {
        this.x = radius * Math.cos(inDegrees ? Math.toRadians(angle) : angle);
        this.y = radius * Math.sin(inDegrees ? Math.toRadians(angle) : angle);
    }

    public static Vector2D subtract(Vector2D vector1, Vector2D vector2) {
        return new Vector2D(vector1.x - vector2.x, vector1.y - vector2.y);
    }

    public static double dotProduct(Vector2D vector1, Vector2D vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y;
    }

    public Vector2D normalize() {
        double magnitude = Math.sqrt(MathEx.sqr(this.x) + MathEx.sqr(this.y));
        return new Vector2D(this.x / magnitude, this.y / magnitude);
    }
}

