/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game;

import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import com.jarbull.mgs.game.MiniGolfMidlet;
import com.jarbull.mgs.game.MiniGolfProcessor;
import com.jarbull.mgs.game.ingame.BottomBar;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.game.ingame.TopBar;
import com.jarbull.mgs.game.screens.LevelEndScreen;
import com.jarbull.mgs.game.screens.SoundConfigScreen;
import com.jarbull.mgs.game.tools.Camera;
import com.jarbull.mgs.game.tools.LevelLoader;
import com.jarbull.mgs.game.tools.MusicPlayer;
import com.jarbull.mgs.game.tools.SFXPlayer;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class MiniGolfCanvas
extends JBGameCanvas
implements Runnable {
    private static final int BAR_HEIGHT = 16;
    private int width;
    private int height;
    private boolean isVibrationOn;
    private boolean isFPSOn;
    private int previousPointerX = 0;
    private int previousPointerY = 0;
    private long previousClickTime = 0L;
    private long lastFrameTime = 0L;
    private boolean initializing = true;
    private MiniGolfMidlet midlet;
    private Camera camera;
    private TopBar topBar;
    private BottomBar bottomBar;
    private LevelEndScreen levelEndScreen;

    public MiniGolfCanvas(MiniGolfMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
        this.width = this.getWidth();
        this.height = this.getHeight() - 32;
        MiniGolfProcessor.getInstance().gauge.setLocation(this.width - 71, this.height + 16 + 1);
        MiniGolfProcessor.getInstance().gauge.setSize(70, 14);
        this.camera = new Camera(GolfCourse.getInstance(), GolfCourse.getInstance().getWidth(), GolfCourse.getInstance().getHeight());
        this.camera.setSize(this.width, this.height);
        this.camera.showPoint(MiniGolfProcessor.getInstance().hole.getX(), MiniGolfProcessor.getInstance().hole.getY());
        this.camera.setCameraType(0, MiniGolfProcessor.getInstance().ball);
        this.setCameraOffset();
        this.topBar = new TopBar(this.width);
        this.topBar.setPosition((this.width - this.topBar.getWidth()) / 2, 0);
        this.topBar.setCameraValue(this.camera.getCameraType());
        this.bottomBar = new BottomBar(this.width);
        this.bottomBar.setPosition((this.width - this.topBar.getWidth()) / 2, this.height + 16);
    }

    private void setCameraOffset() {
        int offsetX = 0;
        int offsetY = 0;
        if (GolfCourse.getInstance().getWidth() < this.width) {
            offsetX = (this.width - GolfCourse.getInstance().getWidth()) / 2;
        }
        if (GolfCourse.getInstance().getHeight() < this.height) {
            offsetY = (this.height - GolfCourse.getInstance().getHeight()) / 2;
        }
        this.camera.setOffset(offsetX, offsetY);
    }

    private void getOptions() {
        MusicPlayer.getInstance().close();
        SFXPlayer.getInstance().close();
        String volume = JBManager.getInstance().menuSettings.get("M2-volume");
        if (volume.equals("LOW")) {
            SFXPlayer.getInstance().setVolume(33);
            MusicPlayer.getInstance().setVolume(33);
        } else if (volume.equals("MEDIUM")) {
            SFXPlayer.getInstance().setVolume(66);
            MusicPlayer.getInstance().setVolume(66);
        } else {
            SFXPlayer.getInstance().setVolume(100);
            MusicPlayer.getInstance().setVolume(100);
        }
        if (JBManager.getInstance().menuSettings.get("M2-music").equals("ON")) {
            SoundConfigScreen soundConfig = new SoundConfigScreen(this.midlet);
            soundConfig.show();
            soundConfig.waitForClose();
            if (soundConfig.getDialogResult() == 1) {
                MusicPlayer.getInstance().open();
                MusicPlayer.getInstance().playMusic();
            }
        } else if (JBManager.getInstance().menuSettings.get("M2-sfx").equals("ON")) {
            SoundConfigScreen soundConfig = new SoundConfigScreen(this.midlet);
            soundConfig.show();
            soundConfig.waitForClose();
            if (soundConfig.getDialogResult() == 1) {
                SFXPlayer.getInstance().open();
            }
        }
        this.isVibrationOn = JBManager.getInstance().menuSettings.get("M2-vibration").equals("ON");
        this.isFPSOn = JBManager.getInstance().menuSettings.get("M2-fps").equals("ON");
    }

    private void showInstructionsScreen() {
        this.levelEndScreen = new LevelEndScreen(this.midlet);
        this.levelEndScreen.setState(1);
        this.levelEndScreen.setNextDisplay((Displayable)this);
        this.levelEndScreen.setTextSpace(4);
        try {
            if (this.getHeight() > 200) {
                this.levelEndScreen.setTopImage(Image.createImage((String)"/res/image/ingame/girl.png"));
            }
            this.levelEndScreen.addText("Rotate CCW    ", Image.createImage((String)"/res/image/ingame/leftarrow.png"));
            this.levelEndScreen.addText("Rotate CW      ", Image.createImage((String)"/res/image/ingame/rightarrow.png"));
            this.levelEndScreen.addText("Stroke ball   ", Image.createImage((String)"/res/image/ingame/fire.png"));
            this.levelEndScreen.addText("Ball Camera   ", Image.createImage((String)"/res/image/ingame/key1.png"));
            this.levelEndScreen.addText("Free Camera  ", Image.createImage((String)"/res/image/ingame/key3.png"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.levelEndScreen.addText(" ");
        this.levelEndScreen.addText("Hit a key for HOLE " + MiniGolfProcessor.getInstance().level);
        this.levelEndScreen.addText("Par " + LevelLoader.getInstance().getPar(MiniGolfProcessor.getInstance().level));
        this.levelEndScreen.show();
        System.gc();
        this.levelEndScreen.setState(0);
        this.levelEndScreen.waitForClose();
        this.initializing = false;
        MiniGolfProcessor.getInstance().startClock();
    }

    private void checkLevelEnd() throws IOException {
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        if (p.hole != null && p.ball != null && p.hole.hasPoint(p.ball.getX() + p.ball.getWidth() / 2, p.ball.getY() + p.ball.getHeight() / 2) && p.ball.velocity < 2.0 && p.ball.isVisible()) {
            SFXPlayer.getInstance().playEffect(3);
            this.endLevel();
        }
    }

    private void endLevel() throws IOException {
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        p.ball.setVisible(false);
        p.hole.stopFlag();
        int levelScore = this.calculateScore(p.strokeCount, p.timePassed);
        p.totalScore += levelScore;
        System.gc();
        this.levelEndScreen.clear();
        this.levelEndScreen.addText(" ");
        this.levelEndScreen.addText("HOLE " + p.level + " COMPLETED");
        this.levelEndScreen.addText(" ");
        this.levelEndScreen.addText("Stroke " + p.strokeCount);
        this.levelEndScreen.addText("Time " + p.timePassed + " sec");
        this.levelEndScreen.addText("Level Score " + levelScore);
        if (++p.level <= 18) {
            if (this.getHeight() > 200) {
                this.levelEndScreen.setTopImage(Image.createImage((String)"/res/image/ingame/bigflag.png"));
            }
            this.levelEndScreen.addText("Total Score " + p.totalScore);
            this.levelEndScreen.addText(" ");
            this.levelEndScreen.addText(" ");
            this.levelEndScreen.addText("LOADING NEXT HOLE", 1);
            this.levelEndScreen.addText("Please be patient", 1);
            this.levelEndScreen.setState(1);
            this.levelEndScreen.show();
            p.loadLevel(p.level);
            this.camera.setBase(GolfCourse.getInstance(), GolfCourse.getInstance().getWidth(), GolfCourse.getInstance().getHeight());
            this.camera.showPoint(p.hole.getX(), p.hole.getY());
            this.setCameraOffset();
            this.camera.setCameraType(0, p.ball);
            p.directionAssistant.attachBall(p.ball);
            p.directionAssistant.visible = true;
            p.ball.setVisible(true);
            this.levelEndScreen.removeTextFromEnd(2);
            this.levelEndScreen.addText("Hit a key for HOLE " + p.level);
            this.levelEndScreen.addText("Par " + LevelLoader.getInstance().getPar(p.level));
            this.levelEndScreen.repaint();
            this.bottomBar.updateScore();
            System.gc();
            this.levelEndScreen.setState(0);
            this.levelEndScreen.waitForClose();
            p.stopClock();
            p.startClock();
        } else {
            this.levelEndScreen.addText(" ");
            this.levelEndScreen.addText("FINAL SCORE " + p.totalScore);
            this.levelEndScreen.addText(" ");
            this.levelEndScreen.addText(" ");
            this.levelEndScreen.addText("CONGRATULATIONS!");
            if (this.getHeight() > 200) {
                this.levelEndScreen.setTopImage(Image.createImage((String)"/res/image/ingame/cup.png"));
            }
            this.levelEndScreen.setState(1);
            this.levelEndScreen.show();
            JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(p.totalScore));
            try {
                if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < p.totalScore) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(p.totalScore));
                }
            }
            catch (Exception ex) {
                JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(p.totalScore));
            }
            JBManager.getInstance().gameSettings.remove("lastLevel");
            JBManager.getInstance().gameSettings.remove("lastScore");
            this.levelEndScreen.setState(0);
            this.levelEndScreen.waitForClose();
            this.midlet.openPauseMenu();
            JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
            this.stopProcessing();
            this.midlet.destroyJBApp(false, null);
        }
    }

    private int calculateScore(int strokeCount, int timePassed) {
        int strokeScore = 0;
        int par = LevelLoader.getInstance().getPar();
        if (strokeCount < par + 11) {
            strokeScore = 220 - (strokeCount - par - 1) * 20;
            if (strokeCount <= par + 2) {
                strokeScore += 50 * (par + 2 - strokeCount);
            }
        }
        int timeScore = 0;
        if (timePassed < 100) {
            timeScore = 100 - timePassed;
        }
        return strokeScore + timeScore;
    }

    public void skipLevel() {
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        if (++p.level <= 18) {
            try {
                p.loadLevel(p.level);
                this.camera.setBase(GolfCourse.getInstance(), GolfCourse.getInstance().getWidth(), GolfCourse.getInstance().getHeight());
                this.camera.showPoint(p.hole.getX(), p.hole.getY());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setCameraOffset();
            this.camera.setCameraType(0, p.ball);
            p.directionAssistant.attachBall(p.ball);
            p.directionAssistant.visible = true;
            p.ball.setVisible(true);
            p.stopClock();
            p.startClock();
        }
    }

    public void restartLevel() {
        MiniGolfProcessor.getInstance().stopClock();
        MiniGolfProcessor.getInstance().restartLevel();
        MiniGolfProcessor.getInstance().startClock();
    }

    public void restartGame() {
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        p.stopClock();
        p.stop();
        p.join();
        p.level = 1;
        p.totalScore = 0;
        p.start();
        p.gauge.setLocation(this.width - 71, this.height + 16 + 1);
        p.gauge.setSize(70, 14);
        this.camera.setBase(GolfCourse.getInstance(), GolfCourse.getInstance().getWidth(), GolfCourse.getInstance().getHeight());
        this.camera.showPoint(p.hole.getX(), p.hole.getY());
        this.setCameraOffset();
        this.camera.setCameraType(0, p.ball);
        this.bottomBar.updateScore();
        p.startClock();
    }

    public void setCameraType(int cameraType) {
        if (cameraType == 0) {
            this.camera.setCameraType(cameraType, MiniGolfProcessor.getInstance().ball);
        } else {
            this.camera.setCameraType(1);
        }
        this.topBar.setCameraValue(cameraType);
    }

    public boolean checkKeys() {
        int keyState = this.getKeyStates();
        if (this.camera.getCameraType() == 1) {
            if ((keyState & 4) != 0) {
                if (this.camera.x > 0) {
                    this.camera.x -= 5;
                }
            } else if ((keyState & 0x20) != 0 && this.camera.x < GolfCourse.getInstance().getWidth() - this.camera.width) {
                this.camera.x += 5;
            }
            if ((keyState & 2) != 0) {
                if (this.camera.y > 0) {
                    this.camera.y -= 5;
                }
            } else if ((keyState & 0x40) != 0 && this.camera.y < GolfCourse.getInstance().getHeight() - this.camera.height) {
                this.camera.y += 5;
            }
        } else if (MiniGolfProcessor.getInstance().directionAssistant.visible && !MiniGolfProcessor.getInstance().gauge.isVisible()) {
            if ((keyState & 4) != 0) {
                MiniGolfProcessor.getInstance().directionAssistant.decreaseAngle();
            }
            if ((keyState & 0x20) != 0) {
                MiniGolfProcessor.getInstance().directionAssistant.increaseAngle();
            }
        }
        return keyState != 0;
    }

    public void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (keyCode) {
            case -202: {
                this.midlet.openPauseMenu();
                break;
            }
            case -203: 
            case 205: 
            case 225: {
                if (this.camera.getCameraType() != 1) {
                    MiniGolfProcessor p = MiniGolfProcessor.getInstance();
                    if (p.directionAssistant.visible && !p.gauge.isVisible()) {
                        p.ball.angle = p.directionAssistant.getAngle();
                        p.gauge.setValue(0);
                        p.gauge.setVisible(true);
                        break;
                    }
                    if (!p.directionAssistant.visible || !p.gauge.isVisible()) break;
                    p.ball.velocity = 4 * ((30 + p.gauge.getValue()) * 10 / 13) / 100;
                    p.gauge.setVisible(false);
                    p.directionAssistant.visible = false;
                    ++p.strokeCount;
                    if (this.isVibrationOn) {
                        Display.getDisplay((MIDlet)this.midlet).vibrate(200);
                    }
                    SFXPlayer.getInstance().playEffect(1);
                    break;
                }
                this.setCameraType(0);
                break;
            }
            case 202: 
            case 221: {
                if (this.camera.getCameraType() == 1 || !MiniGolfProcessor.getInstance().directionAssistant.visible || MiniGolfProcessor.getInstance().gauge.isVisible()) break;
                MiniGolfProcessor.getInstance().directionAssistant.decreaseAngle90();
                break;
            }
            case 208: 
            case 222: {
                if (this.camera.getCameraType() == 1 || !MiniGolfProcessor.getInstance().directionAssistant.visible || MiniGolfProcessor.getInstance().gauge.isVisible()) break;
                MiniGolfProcessor.getInstance().directionAssistant.increaseAngle90();
                break;
            }
            case 201: {
                this.setCameraType(0);
                break;
            }
            case 203: {
                this.setCameraType(1);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (x > this.width - 50 && y < 36) {
            if (this.camera.getCameraType() == 1) {
                this.setCameraType(0);
            } else {
                this.setCameraType(1);
            }
        } else if (this.camera.getCameraType() != 1) {
            MiniGolfProcessor p = MiniGolfProcessor.getInstance();
            if (p.directionAssistant.visible && !p.gauge.isVisible()) {
                if (System.currentTimeMillis() - this.previousClickTime < 500L) {
                    p.ball.angle = p.directionAssistant.getAngle();
                    p.gauge.setValue(0);
                    p.gauge.setVisible(true);
                }
            } else if (p.directionAssistant.visible && p.gauge.isVisible()) {
                p.gauge.setVisible(false);
                p.directionAssistant.visible = false;
                p.ball.velocity = 4 * ((30 + p.gauge.getValue()) * 10 / 13) / 100;
                ++p.strokeCount;
            }
        }
        this.previousClickTime = System.currentTimeMillis();
    }

    public void pointerDragged(int x, int y) {
        if (this.camera.getCameraType() == 1) {
            if (this.previousPointerX > x) {
                if (this.camera.x > 0) {
                    --this.camera.x;
                }
            } else if (this.camera.x > 0) {
                ++this.camera.x;
            }
            if (this.previousPointerY > y) {
                if (this.camera.x > 0) {
                    --this.camera.y;
                }
            } else if (this.camera.x > 0) {
                ++this.camera.y;
            }
            this.previousPointerX = x;
            this.previousPointerY = y;
        } else if (MiniGolfProcessor.getInstance().directionAssistant.visible && !MiniGolfProcessor.getInstance().gauge.isVisible()) {
            if (this.previousPointerX < x) {
                MiniGolfProcessor.getInstance().directionAssistant.increaseAngle();
            } else {
                MiniGolfProcessor.getInstance().directionAssistant.decreaseAngle();
            }
            this.previousPointerX = x;
            this.previousPointerY = y;
        }
        this.previousClickTime = 0L;
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.initializing) {
            g.setColor(0xFFFFFF);
            g.drawString("Loading...", this.getWidth() / 2, this.getHeight() / 2, 65);
            return;
        }
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        if (p.specialSods != null) {
            for (int i = p.specialSods.length - 1; i >= 0; --i) {
                p.specialSods[i].nextFrame();
            }
        }
        this.camera.updateView();
        GolfCourse.getInstance().paint(g, 0, 16);
        p.directionAssistant.paint(g, -this.camera.x + this.camera.offsetX, -this.camera.y + this.camera.offsetY + 16);
        this.topBar.paint(g);
        this.bottomBar.paint(g);
        p.gauge.paint(g);
        if (this.camera.getCameraType() == 1) {
            g.setColor(0xFF0000);
            g.drawString("Free Camera", this.width, this.height + 16, 40);
        }
        if (this.isFPSOn) {
            long frameTime = System.currentTimeMillis();
            long delay = frameTime - this.lastFrameTime;
            this.lastFrameTime = frameTime;
            g.setColor(0);
            g.drawString("FPS: " + 1000L / (delay == 0L ? 1L : delay), 0, 11, 20);
            g.drawString("PPS: " + 1000L / (MiniGolfProcessor.getInstance().delay == 0L ? 1L : MiniGolfProcessor.getInstance().delay), 0, 31, 20);
            g.drawString("FM: " + Runtime.getRuntime().freeMemory() / 1024L + " KB (%" + (int)((double)Runtime.getRuntime().freeMemory() / (double)Runtime.getRuntime().totalMemory() * 100.0) + ")", 0, 51, 20);
        }
    }

    public void run() {
        this.getOptions();
        this.showInstructionsScreen();
        MiniGolfProcessor p = MiniGolfProcessor.getInstance();
        while (p.isPlaying && this.isRunning) {
            long frameStart = System.currentTimeMillis();
            if (!this.isPaused) {
                this.checkKeys();
                this.repaint();
                try {
                    this.checkLevelEnd();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Thread.sleep(Math.max(0L, 50L - System.currentTimeMillis() + frameStart));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        p.stop();
    }
}

