/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.DirectionAssistant;
import com.jarbull.mgs.game.ingame.Gauge;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.game.ingame.Hole;
import com.jarbull.mgs.game.ingame.Nail;
import com.jarbull.mgs.game.ingame.Sand;
import com.jarbull.mgs.game.ingame.SpecialSod;
import com.jarbull.mgs.game.ingame.Wall;
import com.jarbull.mgs.game.ingame.WormHole;
import com.jarbull.mgs.game.tools.ClockTimerTask;
import com.jarbull.mgs.game.tools.LevelLoader;
import com.jarbull.mgs.game.tools.SFXPlayer;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class MiniGolfProcessor
implements Runnable {
    public long delay;
    public int ballStartX;
    public int ballStartY;
    public int level;
    public int strokeCount;
    public int timePassed;
    public int totalScore;
    public boolean isPlaying;
    public boolean isPaused;
    private Thread processorThread;
    public Hole hole;
    public Ball ball;
    public Wall[] walls;
    public Sand[] sands;
    public SpecialSod[] specialSods;
    public WormHole[] wormHoles;
    public Nail[] nails;
    public Timer clock;
    public ClockTimerTask countdownTimer;
    public DirectionAssistant directionAssistant;
    public Gauge gauge;
    private static final MiniGolfProcessor instance = new MiniGolfProcessor();

    private MiniGolfProcessor() {
    }

    public static MiniGolfProcessor getInstance() {
        return instance;
    }

    public void clearProcessor() {
        this.ballStartX = 0;
        this.ballStartY = 0;
        this.strokeCount = 0;
        this.timePassed = 0;
        this.isPlaying = true;
        this.isPaused = false;
        this.hole = null;
        this.ball = null;
        this.walls = null;
        this.sands = null;
        this.specialSods = null;
        this.wormHoles = null;
        this.nails = null;
        this.countdownTimer = null;
        this.clock = new Timer();
        this.directionAssistant = new DirectionAssistant();
        this.gauge = new Gauge();
        System.gc();
    }

    public void start() {
        this.clearProcessor();
        try {
            this.loadLevel(this.level);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.directionAssistant.attachBall(this.ball);
        this.directionAssistant.visible = true;
        this.gauge.setColor(0xFFFF00, 0xFF0000);
        this.gauge.setFlactuation(true);
        this.gauge.setValue(0);
        this.gauge.setVisible(false);
        this.processorThread = new Thread(this);
        this.processorThread.start();
    }

    public void stop() {
        this.isPlaying = false;
    }

    public void join() {
        try {
            this.processorThread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void startClock() {
        this.countdownTimer = new ClockTimerTask(this.timePassed);
        this.clock.schedule((TimerTask)this.countdownTimer, 0L, 1000L);
    }

    public void pauseClock() {
        if (this.countdownTimer != null) {
            this.countdownTimer.cancel();
        }
    }

    public void stopClock() {
        this.timePassed = 0;
        if (this.countdownTimer != null) {
            this.countdownTimer.cancel();
        }
    }

    public void loadLevel(int level) throws IOException {
        this.strokeCount = 0;
        GolfCourse golfCourse = GolfCourse.getInstance();
        for (int i = golfCourse.getSize() - 1; i >= 0; --i) {
            golfCourse.remove(golfCourse.getLayerAt(i));
        }
        this.walls = null;
        this.wormHoles = null;
        this.nails = null;
        this.ball = null;
        this.hole = null;
        this.sands = null;
        this.specialSods = null;
        golfCourse.nullifyCourse();
        System.gc();
        LevelLoader loader = LevelLoader.getInstance();
        loader.setLevel(level);
        this.walls = loader.loadWalls(golfCourse);
        this.wormHoles = loader.loadWormHoles(golfCourse);
        this.nails = loader.loadNails(golfCourse);
        this.ball = loader.loadBall(golfCourse);
        this.hole = loader.loadHole(golfCourse);
        this.sands = loader.loadSands(golfCourse);
        this.specialSods = loader.loadSpecialSods(golfCourse);
        golfCourse.loadCourse();
        this.ballStartX = this.ball.getX();
        this.ballStartY = this.ball.getY();
    }

    public void restartLevel() {
        this.strokeCount = 0;
        this.ball.velocity = 0.0;
        this.ball.setPosition(this.ballStartX, this.ballStartY);
        this.directionAssistant.visible = true;
    }

    private void checkCollisions() {
        int i;
        boolean movedBack = false;
        if (GolfCourse.getInstance().checkCollision(this.ball)) {
            movedBack = GolfCourse.getInstance().responseCollision(this.ball, movedBack);
            SFXPlayer.getInstance().playEffect(2);
        }
        for (i = this.wormHoles.length - 1; i >= 0; --i) {
            if (!this.wormHoles[i].checkCollision(this.ball)) continue;
            movedBack = this.wormHoles[i].responseCollision(this.ball, movedBack);
        }
        for (i = this.walls.length - 1; i >= 0; --i) {
            if (!this.walls[i].checkCollision(this.ball)) continue;
            movedBack = this.walls[i].responseCollision(this.ball, movedBack);
            SFXPlayer.getInstance().playEffect(2);
        }
        for (i = this.nails.length - 1; i >= 0; --i) {
            if (!this.nails[i].checkCollision(this.ball)) continue;
            this.nails[i].responseCollision(this.ball, movedBack);
            SFXPlayer.getInstance().playEffect(2);
        }
        for (i = this.sands.length - 1; i >= 0; --i) {
            if (!this.sands[i].checkCollision(this.ball)) continue;
            this.sands[i].responseCollision(this.ball);
        }
        for (i = this.specialSods.length - 1; i >= 0; --i) {
            if (!this.specialSods[i].checkCollision(this.ball)) continue;
            this.specialSods[i].responseCollision(this.ball);
        }
    }

    public void run() {
        while (this.isPlaying) {
            long frameStart = System.currentTimeMillis();
            if (!this.isPaused && this.ball != null) {
                if (this.ball.velocity == 0.0) {
                    if (!this.directionAssistant.visible && !this.gauge.isVisible()) {
                        this.directionAssistant.visible = true;
                    }
                } else {
                    this.checkCollisions();
                    this.ball.move();
                }
            }
            try {
                this.delay = Math.max(0L, 10L - System.currentTimeMillis() + frameStart);
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

