/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Nail
extends TiledLayer {
    public static final int TILE_WIDTH = 5;
    public static final int TILE_HEIGHT = 5;

    public Nail(GolfCourse golfCourse, int x, int y) throws IOException {
        super(1, 1, Image.createImage((String)"/res/image/ingame/nail.png"), 5, 5);
        this.setCell(0, 0, 1);
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, true);
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        if (!isMovedBack) {
            ball.moveBack();
            isMovedBack = true;
        }
        int ballCenterX = ball.getX() + ball.getWidth() / 2;
        int ballCenterY = ball.getY() + ball.getHeight() / 2;
        int nailCenterX = this.getX() + this.getWidth() / 2;
        int nailCenterY = this.getY() + this.getHeight() / 2;
        ball.reflect(new Vector2D(ballCenterX - nailCenterX, ballCenterY - nailCenterY).normalize());
        return isMovedBack;
    }
}

