/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class SpecialSod
extends TiledLayer {
    public static final double SOD_FRICTION = 0.005;
    public static final double SOD_ANGEL_STEP = 1.0;
    private static final int TILE_WIDTH = 10;
    private static final int TILE_HEIGHT = 10;
    private int[] FRAME_SEQUENCE = new int[]{1, 5, 9, 13, 17, 21, 25};
    private int sequenceIndex = 0;
    private int[] animatedTileIndex;
    private int direction;

    public SpecialSod(GolfCourse golfCourse, int width, int height, int x, int y, int direction) throws IOException {
        super(width / 10, height / 10, Image.createImage((String)"/res/image/ingame/specialsod.png"), 10, 10);
        this.direction = direction;
        int i = this.FRAME_SEQUENCE.length - 1;
        while (i >= 0) {
            int n = i--;
            this.FRAME_SEQUENCE[n] = this.FRAME_SEQUENCE[n] + (direction - 1);
        }
        this.animatedTileIndex = new int[this.FRAME_SEQUENCE.length];
        for (i = this.FRAME_SEQUENCE.length - 1; i >= 0; --i) {
            this.animatedTileIndex[i] = this.createAnimatedTile(this.FRAME_SEQUENCE[this.sequenceIndex + i]);
        }
        for (int i2 = this.getColumns() * this.getRows() - 1; i2 >= 0; --i2) {
            int column = i2 % this.getColumns();
            int row = (i2 - column) / this.getColumns();
            if (column % 2 == 0 && direction == 4) {
                this.setCell(column, row, this.animatedTileIndex[(column + 2 * row) % this.FRAME_SEQUENCE.length]);
                continue;
            }
            if (column % 2 == 0 && direction == 3) {
                this.setCell(column, row, this.animatedTileIndex[(column + 5 * row) % this.FRAME_SEQUENCE.length]);
                continue;
            }
            if (row % 2 == 0 && direction == 1) {
                this.setCell(column, row, this.animatedTileIndex[(row + 2 * column) % this.FRAME_SEQUENCE.length]);
                continue;
            }
            if (row % 2 != 0 || direction != 2) continue;
            this.setCell(column, row, this.animatedTileIndex[(row + 5 * column) % this.FRAME_SEQUENCE.length]);
        }
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.FRAME_SEQUENCE.length;
        for (int i = this.FRAME_SEQUENCE.length - 1; i >= 0; --i) {
            this.setAnimatedTile(this.animatedTileIndex[i], this.FRAME_SEQUENCE[(this.sequenceIndex + i) % this.FRAME_SEQUENCE.length]);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, false);
    }

    public void responseCollision(Ball ball) {
        int directionAngle = 0;
        switch (this.direction) {
            case 1: {
                if (ball.angle > 0.0 && ball.angle < 180.0) {
                    ball.angle -= 1.0;
                    break;
                }
                if (!(ball.angle < 0.0) && !(ball.angle > 180.0)) break;
                ball.angle += 1.0;
                break;
            }
            case 2: {
                directionAngle = 180;
                if (ball.angle > 0.0 && ball.angle < 180.0) {
                    ball.angle += 1.0;
                    break;
                }
                if (!(ball.angle < 0.0) && !(ball.angle > 180.0)) break;
                ball.angle -= 1.0;
                break;
            }
            case 3: {
                directionAngle = 90;
                if (ball.angle > 90.0 && ball.angle < 270.0) {
                    ball.angle += 1.0;
                    break;
                }
                if (!(ball.angle < 90.0) && !(ball.angle > 270.0)) break;
                ball.angle -= 1.0;
                break;
            }
            case 4: {
                directionAngle = 270;
                if (ball.angle > 90.0 && ball.angle < 270.0) {
                    ball.angle -= 1.0;
                    break;
                }
                if (!(ball.angle < 90.0) && !(ball.angle > 270.0)) break;
                ball.angle += 1.0;
            }
        }
        if (ball.angle < 0.0) {
            ball.angle += 360.0;
        } else if (ball.angle >= 360.0) {
            ball.angle -= 360.0;
        }
        if (Math.abs((double)(360 - directionAngle) - ball.angle) < 1.0) {
            ball.velocity += 0.005;
        } else if (Math.abs((double)directionAngle - ball.angle) < 1.0) {
            ball.velocity = ball.velocity > 0.005 ? (ball.velocity -= 0.005) : 0.0;
        }
    }
}

