/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.jbf.JBManager;
import com.jarbull.mgs.game.MiniGolfProcessor;
import com.jarbull.mgs.game.ingame.Bar;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class TopBar {
    private static final int CAMERA_TILE_WIDTH = 11;
    private static final int CAMERA_TILE_HEIGHT = 11;
    private Bar bar;
    private TiledLayer cameraLayer;
    private Image cameraImage;
    private Image clockImage;
    private Image clubImage;
    private final Image[] numbers;

    public TopBar(int width) {
        try {
            this.bar = new Bar(width);
            this.clockImage = Image.createImage((String)"/res/image/ingame/clock.png");
            this.clubImage = Image.createImage((String)"/res/image/ingame/club.png");
            this.cameraImage = Image.createImage((String)"/res/image/ingame/camera.png");
            this.cameraLayer = new TiledLayer(this.cameraImage.getWidth() / 11 - 2, this.cameraImage.getHeight() / 11, this.cameraImage, 11, 11);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.cameraLayer.setCell(0, 0, 1);
        this.cameraLayer.setCell(1, 0, 2);
        this.numbers = new Image[10];
        for (int i = 9; i >= 0; --i) {
            this.numbers[i] = JBManager.getInstance().getTextImage(Integer.toString(i), "10x10");
        }
    }

    public void setPosition(int x, int y) {
        this.bar.setPosition(x, y);
        this.cameraLayer.setPosition(this.bar.getSpecifiedWidth() - this.cameraLayer.getWidth() - 5, this.bar.getY() + (this.bar.getHeight() - this.cameraLayer.getHeight()) / 2);
    }

    public int getWidth() {
        return this.bar.getWidth();
    }

    private void updateTimeValue() {
        try {
            MiniGolfProcessor.getInstance().timePassed = MiniGolfProcessor.getInstance().countdownTimer.getValue();
        }
        catch (Exception ex) {
            MiniGolfProcessor.getInstance().timePassed = 0;
        }
    }

    public void setCameraValue(int cameraType) {
        if (cameraType == 0) {
            this.cameraLayer.setCell(2, 0, 5);
            this.cameraLayer.setCell(3, 0, 4);
        } else {
            this.cameraLayer.setCell(2, 0, 3);
            this.cameraLayer.setCell(3, 0, 6);
        }
    }

    public void paint(Graphics g) {
        int digit;
        this.updateTimeValue();
        this.bar.paint(g);
        int barCenter = this.bar.getY() + 8;
        g.drawImage(this.clockImage, 5, barCenter - 1, 6);
        String time = Integer.toString(MiniGolfProcessor.getInstance().timePassed);
        int digitPosition = 5 + this.clockImage.getWidth() + 2;
        for (int i = 0; i < time.length(); ++i) {
            digit = Integer.parseInt(time.substring(i, i + 1));
            g.drawImage(this.numbers[digit], digitPosition, barCenter, 6);
            digitPosition += this.numbers[digit].getWidth();
        }
        g.drawImage(this.clubImage, 45, barCenter, 6);
        String stroke = Integer.toString(MiniGolfProcessor.getInstance().strokeCount);
        digitPosition = 45 + this.clubImage.getWidth() + 1;
        for (int i = 0; i < stroke.length(); ++i) {
            digit = Integer.parseInt(stroke.substring(i, i + 1));
            g.drawImage(this.numbers[digit], digitPosition, barCenter, 6);
            digitPosition += this.numbers[digit].getWidth();
        }
        this.cameraLayer.paint(g);
    }
}

