/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Category;
import JabpLite.CategoryForm;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.CurrencyStore;
import JabpLite.CurrencyView;
import JabpLite.DateId;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.Regular;
import JabpLite.RegularForm;
import JabpLite.RegularStore;
import JabpLite.Split;
import JabpLite.SplitForm;
import JabpLite.SplitStore;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionForm;
import JabpLite.TransactionStore;
import JabpLite.TransferForm;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class TransactionView
extends Canvas
implements CommandListener,
Runnable {
    Account a;
    Transaction t;
    Transaction t1;
    Transaction oldT;
    Transaction previousT;
    CategoryForm cf;
    Regular r;
    RegularForm rf;
    RegularStore rs;
    SplitForm sf;
    TransferForm trf;
    Form debug;
    TransactionStore ts;
    Alert alert;
    Calendar calendar;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    String msg = "";
    String oldName = "";
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldId;
    int startPos;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int currencyRate;
    int saveAsRegularFlag = 0;

    public TransactionView(JabpLite jabpLite, Display display, Account account) {
        this.parent = jabpLite;
        this.display = display;
        this.a = account;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.regularCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.calendar = Calendar.getInstance();
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.dateWidth = this.font.stringWidth("99/99");
        this.numberWidth = this.font.stringWidth("999999.99");
        this.reconciledWidth = this.font.stringWidth(" r");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.saveAsRegularFlag = 0;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.rs = new RegularStore(this.parent);
        this.ts = new TransactionStore(this.parent, this.a);
        this.numItems = this.ts.getNumTransactions();
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            this.currencyRate = currencyStore.getCurrencyFromName((String)this.a.currency).rate;
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
        if (this.parent.tf2 != null) {
            if (!this.parent.tf2.ready) {
                this.show("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u043e\u0440\u043c\u044b \u0432 \u0444\u043e\u043d\u0435");
            }
            this.parent.tf2.setCommandListener(this);
        }
    }

    void runThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.t = this.ts.getTransactionFromIndex(i + this.startPos);
            this.buildLine(graphics, this.t, this.fontHeight * i + this.fontHeight);
        }
        this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0432" + this.a.name, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        } else {
            graphics.setColor(this.parent.colorRed);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString(this.msg, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        int n = this.a.current;
        int n2 = this.a.today;
        int n3 = this.a.reconciled;
        String string = "";
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            n = Utilities.homeToForeign(n, this.currencyRate);
            n2 = Utilities.homeToForeign(n2, this.currencyRate);
            n3 = Utilities.homeToForeign(n3, this.currencyRate);
            string = "* ";
        }
        string = string + "C:" + Utilities.numberToString(n, false) + " T:" + Utilities.numberToString(n2, false) + " R:" + Utilities.numberToString(n3, false);
        graphics.setColor(0);
        graphics.drawString(string, this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousT = new Transaction();
            this.previousT.clone(this.t);
            this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousT = new Transaction();
            this.previousT.clone(this.t);
            this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    String setPageDate(Date date) {
        this.calendar.setTime(date);
        String string = "" + this.calendar.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.calendar.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        return string + "/" + string2;
    }

    String setReconciled(boolean bl) {
        if (bl) {
            return " r";
        }
        return "";
    }

    void buildLine(Graphics graphics, Transaction transaction, int n) {
        graphics.drawString(this.setPageDate(transaction.date), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
        int n2 = transaction.description.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i;
            if (this.font.stringWidth(transaction.description.substring(0, n3)) > this.descriptionWidth) continue;
            graphics.drawString(transaction.description.substring(0, n3), this.descriptionPosition, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.numberToString(transaction.amount, false);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
        graphics.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.descriptionWidth = this.width - this.numberWidth - this.dateWidth - this.reconciledWidth - this.parent.widthAdjustment * 2 - 30;
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + 10;
        this.amountPosition = this.descriptionPosition + this.descriptionWidth + 10;
    }

    void show(String string) {
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    Transaction showTransaction() {
        this.oldT = new Transaction();
        this.oldT.clone(this.t);
        return this.t;
    }

    int newTransaction(Transaction transaction) {
        this.t1 = transaction;
        if (this.t1.description.equals("")) {
            return 0;
        }
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        this.t1.id = this.ts.saveNewTransaction(this.t1);
        if (this.t == null) {
            this.t = this.t1;
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, null);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (!this.t1.transferFlag) {
            CategoryStore categoryStore = new CategoryStore(this.parent);
            if (this.t1.splitFlag) {
                for (int i = 0; i < this.t1.ss.size(); ++i) {
                    Split split = this.t1.ss.getSplit(i);
                    Category category = categoryStore.getCategoryFromName(split.category);
                    this.updateCategoryTotal1(category);
                    category.updateBalance(split, null);
                    this.updateCategoryTotal2(category);
                    categoryStore.saveExistingCategory(category);
                }
            } else {
                Category category = categoryStore.getCategoryFromName(this.t1.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(this.t1, null);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
            categoryStore.closeCategoryStore();
            categoryStore = null;
        }
        ++this.numItems;
        this.repaint();
        return this.t1.id;
    }

    void editTransaction(Transaction transaction) {
        Category category;
        Object object;
        int n;
        if (transaction.description.equals("")) {
            return;
        }
        this.t1 = transaction;
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        this.ts.saveExistingTransaction(this.t1);
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, this.oldT);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (Utilities.calcDate(this.t1.date) != Utilities.calcDate(this.oldT.date)) {
            this.ts.deleteIndex(this.startPos + this.currentPos);
            this.ts.addIndex(this.t1);
        }
        CategoryStore categoryStore = new CategoryStore(this.parent);
        if (!this.oldT.transferFlag) {
            if (this.oldT.splitFlag) {
                for (n = 0; n < this.oldT.ss.size(); ++n) {
                    object = this.oldT.ss.getSplit(n);
                    category = categoryStore.getCategoryFromName(((Split)object).category);
                    this.updateCategoryTotal1(category);
                    category.updateBalance(null, (Split)object);
                    this.updateCategoryTotal2(category);
                    categoryStore.saveExistingCategory(category);
                }
            } else {
                category = categoryStore.getCategoryFromName(this.oldT.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(null, this.oldT);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        }
        if (this.t1.transferFlag) {
            if (!this.t1.transferAccount.equals(this.t.account) && !this.t1.transferAccount.equals("") && (object = this.ts.getTransaction(n = this.t1.transferAccountId)) != null) {
                this.oldT = new Transaction();
                this.oldT.clone((Transaction)object);
                ((Transaction)object).amount = -this.t1.amount;
                ((Transaction)object).date = this.t1.date;
                Account account = this.parent.av.as.getAccountFromName(((Transaction)object).account);
                TransactionStore transactionStore = new TransactionStore(this.parent, account);
                transactionStore.saveExistingTransaction((Transaction)object);
                if (Utilities.calcDate(((Transaction)object).date) != Utilities.calcDate(this.oldT.date)) {
                    transactionStore.deleteIndex(this.oldT);
                    transactionStore.addIndex((Transaction)object);
                }
                transactionStore.closeTransactionStore();
                transactionStore = null;
                this.updateAccountTotal1(account);
                account.updateBalance((Transaction)object, this.oldT);
                this.updateAccountTotal2(account);
                this.parent.av.as.saveExistingAccount(account);
                account = null;
            }
        } else if (this.t1.splitFlag) {
            for (n = 0; n < this.t1.ss.size(); ++n) {
                object = this.t1.ss.getSplit(n);
                category = categoryStore.getCategoryFromName(((Split)object).category);
                this.updateCategoryTotal1(category);
                category.updateBalance((Split)object, null);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        } else {
            category = categoryStore.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(category);
            category.updateBalance(this.t1, null);
            this.updateCategoryTotal2(category);
            categoryStore.saveExistingCategory(category);
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
        this.oldY = this.currentY;
        this.repaint();
    }

    void deleteTransaction(Transaction transaction) {
        this.t1 = transaction;
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(null, this.t1);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        if (this.t1.transferFlag) {
            int n;
            Transaction transaction2;
            if (!this.t1.transferAccount.equals(this.t.account) && !this.t1.transferAccount.equals("") && (transaction2 = this.ts.getTransaction(n = this.t1.transferAccountId)) != null) {
                Account account = this.parent.av.as.getAccountFromName(transaction2.account);
                TransactionStore transactionStore = new TransactionStore(this.parent, account);
                transactionStore.deleteTransaction(transaction2);
                transactionStore.deleteIndex(transaction2);
                transactionStore.closeTransactionStore();
                transactionStore = null;
                this.updateAccountTotal1(account);
                account.updateBalance(null, transaction2);
                this.updateAccountTotal2(account);
                this.parent.av.as.saveExistingAccount(account);
                account = null;
            }
        } else if (this.t1.splitFlag) {
            for (int i = 0; i < this.t1.ss.size(); ++i) {
                Split split = this.t1.ss.getSplit(i);
                Category category = categoryStore.getCategoryFromName(split.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(null, split);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        } else {
            Category category = categoryStore.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(category);
            category.updateBalance(null, this.t1);
            this.updateCategoryTotal2(category);
            categoryStore.saveExistingCategory(category);
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
        this.ts.deleteTransaction(this.t1);
        this.ts.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
    }

    void updateAccountTotal1(Account account) {
        this.parent.av.totalToday -= account.today;
        this.parent.av.totalReconciled -= account.reconciled;
    }

    void updateAccountTotal2(Account account) {
        this.parent.av.totalToday += account.today;
        this.parent.av.totalReconciled += account.reconciled;
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
        }
    }

    void saveAsRegular() {
        int n;
        this.r = new Regular();
        this.r.description = this.t1.description;
        this.r.amount = this.t1.amount;
        if (this.saveAsRegularFlag == 1) {
            this.r.amount = 0;
        }
        this.r.reference = this.t1.reference;
        this.r.category = this.t1.category;
        this.r.transferFlag = this.t1.transferFlag;
        this.r.transferAccount = this.t1.transferAccount;
        this.r.splitFlag = this.t1.splitFlag;
        if (this.t1.splitFlag) {
            this.r.ss = new SplitStore();
            for (n = 0; n < this.t1.ss.size(); ++n) {
                Split split = new Split();
                split = this.t1.ss.getSplit(n);
                if (this.saveAsRegularFlag == 1) {
                    split.amount = 0;
                }
                this.r.ss.addSplit(split);
            }
        }
        if ((n = this.rs.lookUpId(this.r)) == 0) {
            this.r.id = this.rs.saveNewRegular(this.r);
        } else {
            this.rs.saveExistingRegular(this.r);
        }
        this.saveAsRegularFlag = 0;
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey || n == -5) {
            if (this.numItems == 0) {
                return;
            }
            this.oldT = new Transaction();
            this.oldT.clone(this.t);
            this.t.reconciled = !this.t.reconciled;
            this.editTransaction(this.t);
            return;
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\u0438\u0437" + this.ts.getNumAllTransactions() + "\n");
            short s = (short)n2;
            int n3 = ((DateId)this.ts.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID " + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u0438\u043d\u044b" + this.ts.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0437\u0430\u043f\u0438\u0441\u0438" + this.ts.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
        this.oldT = new Transaction();
        this.oldT.clone(this.t);
        this.t.reconciled = !this.t.reconciled;
        this.editTransaction(this.t);
    }

    void removeAllCommands() {
        this.parent.tf2.removeCommand(this.parent.createCommand);
        this.parent.tf2.removeCommand(this.parent.saveAsRegularCommand);
        this.parent.tf2.removeCommand(this.parent.newCategoryCommand);
        this.parent.tf2.removeCommand(this.parent.cancelCommand);
        this.parent.tf2.removeCommand(this.parent.deleteCommand);
        this.parent.tf2.removeCommand(this.parent.updateCommand);
        this.parent.tf2.removeCommand(this.parent.exitCommand);
    }

    void checkForm() {
        if (this.parent.reuseForm) {
            return;
        }
        if (this.parent.createFormsInBackground) {
            this.runThread();
        } else {
            this.run();
        }
    }

    public void run() {
        this.parent.tf2 = new TransactionForm(this.parent);
        this.parent.tf2.build(false);
        this.parent.tf2.setCommandListener(this);
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        Object object;
        Object object2;
        int n;
        Transaction transaction;
        if (command == this.parent.exitCommand) {
            this.ts.setIndex(this.a);
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                if (this.parent.tf2 == null) {
                    this.run();
                }
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                transaction = new Transaction();
                transaction.account = this.a.name;
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.set(transaction, "\u041d\u043e\u0432\u044b\u0439");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.regularCommand) {
                int n2;
                if (this.parent.tf2 == null) {
                    this.run();
                }
                if ((n2 = this.rs.getNumRegulars()) == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u0435 \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.rf = new RegularForm(this.parent, this.rs);
                this.rf.addCommand(this.parent.okCommand);
                this.rf.addCommand(this.parent.deleteCommand);
                this.rf.addCommand(this.parent.cancelCommand);
                this.rf.addCommand(this.parent.exitCommand);
                this.rf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.rf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.parent.tf2 == null) {
                    this.run();
                }
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.updateCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.set(this.showTransaction(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.parent.tf2 == null) {
                    this.run();
                }
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.deleteCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.set(this.showTransaction(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.mainCommand) {
                this.ts.setIndex(this.a);
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
        }
        if (displayable == this.parent.tf2) {
            if (command == this.parent.createCommand) {
                this.t1 = this.parent.tf2.update();
                if (this.t1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.category.equals("") && !this.t1.splitFlag && !this.t1.transferFlag) {
                    this.alert.setString("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.transferFlag) {
                    this.trf = new TransferForm(this.parent, this.t1, null, "\u041f\u0435\u0440\u0435\u0432\u043e\u0434");
                    this.trf.addCommand(this.parent.okCommand);
                    this.trf.addCommand(this.parent.exitCommand);
                    this.trf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.trf);
                    return;
                }
                if (this.t1.splitFlag) {
                    this.sf = new SplitForm(this.parent, this.t1, "\u041d\u043e\u0432\u044b\u0439");
                    this.sf.addCommand(this.parent.okCommand);
                    this.sf.addCommand(this.parent.exitCommand);
                    this.sf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.sf);
                    return;
                }
                this.newTransaction(this.t1);
                if (this.saveAsRegularFlag > 0) {
                    this.saveAsRegular();
                }
                this.saveAsRegularFlag = 0;
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.updateCommand) {
                this.t1 = this.parent.tf2.update();
                if (this.t1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.category.equals("") && !this.t1.splitFlag && !this.t1.transferFlag) {
                    this.alert.setString("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (!this.oldT.transferFlag && this.t1.transferFlag) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 - \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.oldT.transferFlag && !this.t1.transferFlag) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043e\u0442 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 - \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.splitFlag) {
                    this.sf = new SplitForm(this.parent, this.t1, "\u041d\u043e\u0432\u044b\u0439");
                    this.sf.addCommand(this.parent.updateCommand);
                    this.sf.addCommand(this.parent.exitCommand);
                    this.sf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.sf);
                } else {
                    this.editTransaction(this.t1);
                    this.checkForm();
                    this.display.setCurrent((Displayable)this);
                }
            }
            if (command == this.parent.deleteCommand) {
                this.parent.tf2.clearCategories();
                this.deleteTransaction(this.t);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.newCategoryCommand) {
                this.cf = new CategoryForm(this.parent, new Category(), "\u041d\u043e\u0432\u044b\u0439");
                this.cf.addCommand(this.parent.createCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.saveAsRegularCommand) {
                this.saveAsRegularFlag = 1;
                if (this.parent.tf2.checkAmount() != 0) {
                    this.saveAsRegularFlag = 2;
                }
                this.alert.setString("\u0411\u0443\u0434\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u043a\u0430\u043a \u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u0439");
                this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.parent.tf2.clearCategories();
                this.checkForm();
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.trf && command == this.parent.okCommand) {
            transaction = this.trf.updateTransfer();
            if (transaction.account.equals(this.a.name)) {
                this.alert.setString("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u0443\u044e \u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c");
                this.display.setCurrent(this.alert, (Displayable)this.trf);
                return;
            }
            this.t1.transferAccount = transaction.account;
            transaction.transferAccountId = n = this.newTransaction(this.t1);
            object2 = this.parent.av.as.getAccountFromName(transaction.account);
            object = new TransactionStore(this.parent, (Account)object2);
            int n3 = ((TransactionStore)object).saveNewTransaction(transaction);
            ((TransactionStore)object).closeTransactionStore();
            object = null;
            this.updateAccountTotal1((Account)object2);
            ((Account)object2).updateBalance(transaction, null);
            this.updateAccountTotal2((Account)object2);
            this.parent.av.as.saveExistingAccount((Account)object2);
            object2 = null;
            this.t1 = this.ts.getTransaction(n);
            this.t1.transferAccountId = n3;
            this.ts.saveExistingTransaction(this.t1);
            if (this.saveAsRegularFlag > 0) {
                this.saveAsRegular();
            }
            this.saveAsRegularFlag = 0;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.sf) {
            if (command == this.parent.okCommand) {
                this.t1 = this.sf.updateSplitAmounts();
                if (this.t1.splitFlag) {
                    int n4 = 0;
                    for (n = 0; n < this.t1.ss.size(); ++n) {
                        n4 += this.t1.ss.getSplit((int)n).amount;
                    }
                    if (this.t1.amount != n4) {
                        this.alert.setString("\u0418\u0442\u043e\u0433\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
                        this.display.setCurrent(this.alert, (Displayable)this.sf);
                        return;
                    }
                }
                this.sf = null;
                if (this.t1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                this.newTransaction(this.t1);
                if (this.saveAsRegularFlag > 0) {
                    this.saveAsRegular();
                }
                this.saveAsRegularFlag = 0;
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.updateCommand) {
                this.t1 = this.sf.updateSplitAmounts();
                if (this.t1.splitFlag) {
                    int n5 = 0;
                    for (n = 0; n < this.t1.ss.size(); ++n) {
                        n5 += this.t1.ss.getSplit((int)n).amount;
                    }
                    if (this.t1.amount != n5) {
                        this.alert.setString("\u0418\u0442\u043e\u0433\u043e \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
                        this.display.setCurrent(this.alert, (Displayable)this.sf);
                        return;
                    }
                }
                this.sf = null;
                if (this.t1.description.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                this.editTransaction(this.t1);
                this.display.setCurrent((Displayable)this);
            }
        }
        if (displayable == this.cf) {
            if (command == this.parent.createCommand) {
                Category category = this.cf.update();
                if (category.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                for (n = 0; n < this.parent.categoryHt.size(); ++n) {
                    object2 = (NameId)this.parent.categoryHt.get(new Short((short)n));
                    if (!category.name.equals(((NameId)object2).name)) continue;
                    this.alert.setString("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 ");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.cf = null;
                if (this.parent.cv == null) {
                    this.parent.cv = new CategoryView(this.parent, this.display);
                }
                this.parent.cv.newCategory(category);
                n = 0;
                for (int i = 0; i < this.parent.categoryHt.size(); ++i) {
                    object = (NameId)this.parent.categoryHt.get(new Short((short)i));
                    if (!category.name.equals(((NameId)object).name)) continue;
                    n = i;
                    break;
                }
                this.t1 = this.parent.tf2.update();
                this.parent.tf2.cgCategory.insert(n, category.name, null);
                this.parent.tf2.cgCategory.setSelectedIndex(n, true);
                this.parent.tf2.set(this.t1, "\u041d\u043e\u0432\u044b\u0439");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.cancelCommand) {
                this.cf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.rf) {
            if (command == this.parent.okCommand) {
                this.rf.removeCommand(this.parent.okCommand);
                this.rf.removeCommand(this.parent.deleteCommand);
                this.rf.removeCommand(this.parent.cancelCommand);
                this.rf.removeCommand(this.parent.exitCommand);
                Regular regular = this.rf.update();
                this.rf = null;
                this.t1 = new Transaction();
                this.t1.account = this.a.name;
                this.t1.description = regular.description;
                this.t1.amount = regular.amount;
                this.t1.reference = regular.reference;
                this.t1.category = regular.category;
                this.t1.transferFlag = regular.transferFlag;
                this.t1.transferAccount = regular.transferAccount;
                this.t1.splitFlag = regular.splitFlag;
                if (this.t1.splitFlag) {
                    this.t1.ss = new SplitStore();
                    for (n = 0; n < regular.ss.size(); ++n) {
                        Split split = new Split();
                        split = regular.ss.getSplit(n);
                        this.t1.ss.addSplit(split);
                    }
                }
                this.parent.tf2.set(this.t1, "\u041d\u043e\u0432\u044b\u0439");
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.deleteCommand) {
                Regular regular = this.rf.update();
                this.rf = null;
                n = this.rs.lookUpIndex(regular);
                this.rs.deleteRegular(regular);
                this.rs.deleteIndex(n);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.rf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.ts.setIndex(this.a);
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

