/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.JabpLite;
import JabpLite.StandingOrder;
import JabpLite.Utilities;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class StandingOrderForm
extends Form
implements Runnable {
    boolean ready = false;
    StandingOrder so;
    StandingOrder so1;
    String s1;
    JabpLite parent;
    DateField df1;
    DateField df2;
    TextField tfDescription;
    TextField tfReference;
    TextField tfAmount;
    TextField tfInterval;
    ChoiceGroup cgDRCR;
    ChoiceGroup cgPeriod;
    ChoiceGroup cgAccount;
    ChoiceGroup cgCategory;
    ChoiceGroup cgCurrency;
    ChoiceGroup cgTransfer;

    public StandingOrderForm(JabpLite jabpLite) {
        super("\u041d\u043e\u0432\u043e\u0435 \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u0435");
        this.parent = jabpLite;
    }

    void build() {
        this.append("\u0421\u043e\u0437\u0434\u0430\u044e \u0444\u043e\u0440\u043c\u0443... \u0436\u0434\u0438\u0442\u0435...");
        this.tfDescription = new TextField("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", "", 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfAmount = new TextField("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", "", 64, n);
        this.append((Item)this.tfAmount);
        this.cgDRCR = new ChoiceGroup("DR/CR", 1);
        this.cgDRCR.append("\u0414\u0435\u0431\u0438\u0442", null);
        this.cgDRCR.append("\u041a\u0440\u0435\u0434\u0438\u0442", null);
        this.append((Item)this.cgDRCR);
        this.tfReference = new TextField("Reference", "", 64, 0);
        this.append((Item)this.tfReference);
        this.df1 = new DateField("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0414\u0430\u0442\u044b", 1);
        this.df1.setDate(new Date());
        this.append((Item)this.df1);
        this.df2 = new DateField("\u041a\u043e\u043d\u0435\u0446 \u0414\u0430\u0442\u044b", 1);
        this.df2.setDate(new Date());
        this.append((Item)this.df2);
        this.cgPeriod = new ChoiceGroup("\u041f\u0435\u0440\u0438\u043e\u0434", 1);
        this.cgPeriod.append("\u0415\u0436\u0435\u0433\u043e\u0434\u043d\u043e", null);
        this.cgPeriod.append("\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e", null);
        this.cgPeriod.append("\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e", null);
        this.append((Item)this.cgPeriod);
        this.tfInterval = new TextField("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b", "", 2, 2);
        this.append((Item)this.tfInterval);
        this.cgTransfer = new ChoiceGroup("\u041f\u0435\u0440\u0435\u0432\u043e\u0434", 1);
        this.cgTransfer.append("\u041d\u0435\u0442", null);
        this.cgTransfer.append("\u0414\u0430", null);
        this.append((Item)this.cgTransfer);
        this.cgAccount = new ChoiceGroup("\u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u044c", 1);
        AccountStore accountStore = new AccountStore(this.parent);
        int n2 = accountStore.getNumAccounts();
        for (int i = 0; i < n2; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            this.cgAccount.append(account.name, null);
        }
        this.append((Item)this.cgAccount);
        accountStore.closeAccountStore();
        accountStore = null;
        this.cgCategory = new ChoiceGroup("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", 1);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        n2 = categoryStore.getNumCategories();
        for (int i = 0; i < n2; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            this.cgCategory.append(category.name, null);
        }
        this.append((Item)this.cgCategory);
        categoryStore.closeCategoryStore();
        categoryStore = null;
        this.delete(0);
        this.ready = true;
    }

    StandingOrder update() {
        this.so.description = this.tfDescription.getString();
        int n = this.so.amount;
        this.so.amount = Utilities.stringToNumber(this.tfAmount.getString(), n, this.parent.numericEntry);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.so.amount = -this.so.amount;
        }
        this.so.reference = this.tfReference.getString();
        this.so.processingDate = this.df1.getDate();
        this.so.endDate = this.df2.getDate();
        this.so.startDate = this.so.processingDate;
        this.so.period = this.cgPeriod.getSelectedIndex();
        this.so.interval = Integer.valueOf(this.tfInterval.getString());
        this.so.account = this.cgAccount.getString(this.cgAccount.getSelectedIndex());
        this.so.transferFlag = this.cgTransfer.getSelectedIndex() != 0;
        if (this.so.transferFlag) {
            return this.so;
        }
        this.so.category = this.cgCategory.getString(this.cgCategory.getSelectedIndex());
        return this.so;
    }

    void set(StandingOrder standingOrder, String string) {
        this.so = standingOrder;
        this.s1 = string;
        if (this.ready) {
            this.run();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        this.setTitle(this.s1 + "\u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u0435");
        this.tfDescription.setString(this.so.description);
        String string = "";
        if (this.so.amount != 0) {
            string = Utilities.numberToString(Math.abs(this.so.amount), this.parent.numericEntry);
        }
        this.tfAmount.setString(string);
        if (this.so.amount <= 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.tfReference.setString(this.so.reference);
        this.df1.setDate(this.so.processingDate);
        this.df2.setDate(this.so.endDate);
        this.cgPeriod.setSelectedIndex(this.so.period, true);
        String string2 = "";
        this.tfInterval.setString(String.valueOf(this.so.interval));
        if (!this.so.transferFlag) {
            this.cgTransfer.setSelectedIndex(0, true);
        }
        if (this.so.transferFlag) {
            this.cgTransfer.setSelectedIndex(1, true);
        }
        while (!this.ready) {
        }
        AccountStore accountStore = new AccountStore(this.parent);
        int n = accountStore.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            if (!account.name.equals(this.so.account)) continue;
            this.cgAccount.setSelectedIndex(i, true);
            break;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        CategoryStore categoryStore = new CategoryStore(this.parent);
        n = categoryStore.getNumCategories();
        for (int i = 0; i < n; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            if (!category.name.equals(this.so.category)) continue;
            this.cgCategory.setSelectedIndex(i, true);
            break;
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
    }
}

