/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.xml.Element;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLElement
extends Element {
    public static final int TAG_CSS_SELECTOR = -2;
    public static final int TAG_UNSUPPORTED = -1;
    public static final int TAG_BODY = 0;
    public static final int TAG_HEAD = 1;
    public static final int TAG_HTML = 2;
    public static final int TAG_TITLE = 3;
    public static final int TAG_ABBR = 4;
    public static final int TAG_ACRONYM = 5;
    public static final int TAG_ADDRESS = 6;
    public static final int TAG_BLOCKQUOTE = 7;
    public static final int TAG_BR = 8;
    public static final int TAG_CITE = 9;
    public static final int TAG_CODE = 10;
    public static final int TAG_DFN = 11;
    public static final int TAG_DIV = 12;
    public static final int TAG_EM = 13;
    public static final int TAG_H1 = 14;
    public static final int TAG_H2 = 15;
    public static final int TAG_H3 = 16;
    public static final int TAG_H4 = 17;
    public static final int TAG_H5 = 18;
    public static final int TAG_H6 = 19;
    public static final int TAG_KBD = 20;
    public static final int TAG_P = 21;
    public static final int TAG_PRE = 22;
    public static final int TAG_Q = 23;
    public static final int TAG_SAMP = 24;
    public static final int TAG_SPAN = 25;
    public static final int TAG_STRONG = 26;
    public static final int TAG_VAR = 27;
    public static final int TAG_A = 28;
    public static final int TAG_DL = 29;
    public static final int TAG_DT = 30;
    public static final int TAG_DD = 31;
    public static final int TAG_OL = 32;
    public static final int TAG_UL = 33;
    public static final int TAG_LI = 34;
    public static final int TAG_FORM = 35;
    public static final int TAG_INPUT = 36;
    public static final int TAG_LABEL = 37;
    public static final int TAG_SELECT = 38;
    public static final int TAG_OPTION = 39;
    public static final int TAG_TEXTAREA = 40;
    public static final int TAG_CAPTION = 41;
    public static final int TAG_TABLE = 42;
    public static final int TAG_TD = 43;
    public static final int TAG_TH = 44;
    public static final int TAG_TR = 45;
    public static final int TAG_IMG = 46;
    public static final int TAG_OBJECT = 47;
    public static final int TAG_PARAM = 48;
    public static final int TAG_META = 49;
    public static final int TAG_LINK = 50;
    public static final int TAG_BASE = 51;
    public static final int TAG_HR = 52;
    public static final int TAG_OPTGROUP = 53;
    public static final int TAG_STYLE = 54;
    public static final int TAG_B = 55;
    public static final int TAG_I = 56;
    public static final int TAG_BIG = 57;
    public static final int TAG_SMALL = 58;
    public static final int TAG_FIELDSET = 59;
    public static final int TAG_TEXT = 60;
    static final String[] TAG_NAMES = new String[]{"body", "head", "html", "title", "abbr", "acronym", "address", "blockquote", "br", "cite", "code", "dfn", "div", "em", "h1", "h2", "h3", "h4", "h5", "h6", "kbd", "p", "pre", "q", "samp", "span", "strong", "var", "a", "dl", "dt", "dd", "ol", "ul", "li", "form", "input", "label", "select", "option", "textarea", "caption", "table", "td", "th", "tr", "img", "object", "param", "meta", "link", "base", "hr", "optgroup", "style", "b", "i", "big", "small", "fieldset", "text"};
    public static final int ATTR_CLASS = 0;
    public static final int ATTR_ID = 1;
    public static final int ATTR_STYLE = 2;
    public static final int ATTR_TITLE = 3;
    public static final int ATTR_XMLNS = 4;
    public static final int ATTR_XMLLANG = 5;
    public static final int ATTR_ALIGN = 6;
    public static final int ATTR_BGCOLOR = 7;
    public static final int ATTR_LINK = 8;
    public static final int ATTR_TEXT = 9;
    public static final int ATTR_VERSION = 10;
    public static final int ATTR_CITE = 11;
    public static final int ATTR_ACCESSKEY = 12;
    public static final int ATTR_CHARSET = 13;
    public static final int ATTR_HREF = 14;
    public static final int ATTR_HREFLANG = 15;
    public static final int ATTR_REL = 16;
    public static final int ATTR_REV = 17;
    public static final int ATTR_TABINDEX = 18;
    public static final int ATTR_TYPE = 19;
    public static final int ATTR_ACTION = 20;
    public static final int ATTR_ENCTYPE = 21;
    public static final int ATTR_METHOD = 22;
    public static final int ATTR_WIDTH = 23;
    public static final int ATTR_HEIGHT = 24;
    public static final int ATTR_ALT = 25;
    public static final int ATTR_HSPACE = 26;
    public static final int ATTR_VSPACE = 27;
    public static final int ATTR_LONGDESC = 28;
    public static final int ATTR_LOCALSRC = 29;
    public static final int ATTR_SRC = 30;
    public static final int ATTR_SIZE = 31;
    public static final int ATTR_CHECKED = 32;
    public static final int ATTR_EMPTYOK = 33;
    public static final int ATTR_FORMAT = 34;
    public static final int ATTR_ISTYLE = 35;
    public static final int ATTR_MAXLENGTH = 36;
    public static final int ATTR_NAME = 37;
    public static final int ATTR_VALUE = 38;
    public static final int ATTR_FOR = 39;
    public static final int ATTR_XMLSPACE = 40;
    public static final int ATTR_MULTIPLE = 41;
    public static final int ATTR_SELECTED = 42;
    public static final int ATTR_ABBR = 43;
    public static final int ATTR_AXIS = 44;
    public static final int ATTR_COLSPAN = 45;
    public static final int ATTR_HEADERS = 46;
    public static final int ATTR_ROWSPAN = 47;
    public static final int ATTR_SCOPE = 48;
    public static final int ATTR_VALIGN = 49;
    public static final int ATTR_START = 50;
    public static final int ATTR_MEDIA = 51;
    public static final int ATTR_LABEL = 52;
    public static final int ATTR_SUMMARY = 53;
    public static final int ATTR_CONTENT = 54;
    public static final int ATTR_HTTPEQUIV = 55;
    public static final int ATTR_SCHEME = 56;
    public static final int ATTR_COLS = 57;
    public static final int ATTR_ROWS = 58;
    public static final int ATTR_DIR = 59;
    public static final int ATTR_BORDER = 60;
    private static final String[] ATTRIBUTE_NAMES = new String[]{"class", "id", "style", "title", "xmlns", "xml:lang", "align", "bgcolor", "link", "text", "version", "cite", "accesskey", "charset", "href", "hreflang", "rel", "rev", "tabindex", "type", "action", "enctype", "method", "width", "height", "alt", "hspace", "vspace", "longdesc", "localsrc", "src", "size", "checked", "emptyok", "format", "istyle", "maxlength", "name", "value", "for", "xml:space", "multiple", "selected", "abbr", "axis", "colspan", "headers", "rowspan", "scope", "valign", "start", "media", "label", "summary", "content", "http-equiv", "scheme", "cols", "rows", "dir", "border"};
    private static final int[] COMMON_ATTRIBUTES = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[][] TAG_ATTRIBUTES = new int[][]{{7, 8, 9}, new int[0], {59}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {6}, new int[0], {6}, {6}, {6}, {6}, {6}, {6}, new int[0], {6}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {12, 14, 37}, new int[0], new int[0], new int[0], {50, 19}, new int[0], {19, 38}, {20, 21, 22}, {12, 32, 33, 34, 36, 37, 31, 30, 18, 19, 38}, {12, 39}, {41, 37, 31, 18}, {42, 38}, {12, 57, 37, 58, 18}, {6}, {60}, {6, 45, 47, 49, 23, 24}, {6, 45, 47, 49, 23, 24}, {6, 49}, {6, 25, 24, 26, 30, 27, 23}, new int[0], new int[0], {54, 55}, {14, 51, 16, 19}, {14}, {6, 31, 23}, {52}, {51, 19}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]};
    static final int TYPE_NUMBER = 0;
    static final int TYPE_PIXELS_OR_PERCENTAGE = 1;
    static final int TYPE_COLOR = 2;
    static final int TYPE_ALIGN = 3;
    static final int TYPE_CHAR = 4;
    static final int TYPE_URL = 5;
    static final int TYPE_CDATA = 6;
    static final int TYPE_NMTOKENS = 7;
    static final int TYPE_ID = 8;
    static final int TYPE_XMLNS = 9;
    static final int TYPE_LANG_CODE = 10;
    static final int TYPE_VERSION = 11;
    static final int TYPE_HTTP_METHOD = 12;
    static final int TYPE_BOOLEAN = 13;
    static final int TYPE_CHECKED = 14;
    static final int TYPE_IDREF = 15;
    static final int TYPE_PRESERVE = 16;
    static final int TYPE_MULTIPLE = 17;
    static final int TYPE_SELECTED = 18;
    static final int TYPE_IDREFS = 19;
    static final int TYPE_SCOPE = 20;
    static final int TYPE_VALIGN = 21;
    static final int TYPE_NMTOKEN = 22;
    static final int TYPE_DIRECTION = 23;
    static final int TYPE_CSS_LENGTH = 24;
    static final int TYPE_CSS_LENGTH_OR_PERCENTAGE = 25;
    static final int TYPE_CSS_URL = 26;
    private static final int[] ATTRIBUTE_TYPES = new int[]{7, 8, 6, 6, 9, 10, 3, 2, 2, 2, 11, 5, 4, 6, 5, 10, 7, 7, 0, 6, 5, 6, 12, 1, 1, 6, 0, 0, 5, 6, 5, 6, 14, 13, 6, 6, 0, 6, 6, 15, 16, 17, 18, 6, 6, 0, 19, 0, 20, 21, 0, 6, 6, 6, 6, 22, 6, 0, 0, 23, 0};
    private static String[][] ALLOWED_STRINGS = new String[][]{null, null, null, {"left", "right", "top", "bottom", "center", "middle", "justify"}, null, null, null, null, null, null, null, null, {"get", "post"}, {"true", "false"}, {"checked"}, null, {"default", "preserve"}, {"multiple"}, {"selected"}, null, {"row", "col"}, {"top", "bottom", "middle"}, null, {"ltr", "rtl"}};
    private static final int DIGITS = 1;
    private static final int HEX = 2;
    private static final int ABC = 4;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_FUCHSIA = 0xFF00FF;
    public static final int COLOR_GRAY = 0x808080;
    public static final int COLOR_GREEN = 32768;
    public static final int COLOR_LIME = 65280;
    public static final int COLOR_MAROON = 0x800000;
    public static final int COLOR_NAVY = 128;
    public static final int COLOR_OLIVE = 0x808000;
    public static final int COLOR_PURPLE = 0x800080;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_SILVER = 0xC0C0C0;
    public static final int COLOR_TEAL = 32896;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_YELLOW = 0xFFFF00;
    static final String[] COLOR_STRINGS = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    static final int[] COLOR_VALS = new int[]{65535, 0, 255, 0xFF00FF, 0x808080, 32768, 65280, 0x800000, 128, 0x808000, 0x800080, 0xFF0000, 0xC0C0C0, 32896, 0xFFFFFF, 0xFFFF00};
    private int id = -1;
    private Vector comps;
    private boolean calculatedUi = false;

    static int getColor(String colorStr, int defaultColor) {
        if (colorStr == null || colorStr.equals("")) {
            return defaultColor;
        }
        if (colorStr.charAt(0) != '#') {
            if (colorStr.startsWith("rgb(")) {
                colorStr = colorStr.substring(4);
                char[] tokens = new char[]{',', ',', ')'};
                int weight = 65536;
                int color = 0;
                for (int i = 0; i < 3; ++i) {
                    int index = colorStr.indexOf(tokens[i]);
                    if (index == -1) {
                        return defaultColor;
                    }
                    String channelStr = colorStr.substring(0, index).trim();
                    int channel = HTMLComponent.calcSize(255, channelStr, 0, true);
                    channel = Math.min(channel, 255);
                    channel = Math.max(channel, 0);
                    color += channel * weight;
                    colorStr = colorStr.substring(index + 1);
                    weight /= 256;
                }
                return color;
            }
            for (int i = 0; i < COLOR_STRINGS.length; ++i) {
                if (!colorStr.equalsIgnoreCase(COLOR_STRINGS[i])) continue;
                return COLOR_VALS[i];
            }
        } else {
            colorStr = colorStr.substring(1);
        }
        if (colorStr.length() == 3) {
            String newColStr = "";
            for (int i = 0; i < 3; ++i) {
                newColStr = newColStr + colorStr.charAt(i) + "" + colorStr.charAt(i);
            }
            colorStr = newColStr;
        }
        try {
            int color = Integer.parseInt(colorStr, 16);
            return color;
        }
        catch (NumberFormatException nfe) {
            return defaultColor;
        }
    }

    protected HTMLElement() {
    }

    public HTMLElement(String name) {
        this.init(name);
    }

    private void init(String name) {
        int i = 0;
        int tagId = -1;
        while (tagId == -1 && i < TAG_NAMES.length - 1) {
            if (TAG_NAMES[i].equals(name)) {
                tagId = i;
                continue;
            }
            ++i;
        }
        this.id = tagId;
        if (this.id == -1) {
            this.setName(name);
        }
    }

    public HTMLElement(String name, boolean isTextElement) {
        this.setTextElement(isTextElement);
        if (isTextElement) {
            this.setName(name);
            this.id = 60;
        } else {
            this.init(name);
        }
    }

    void setAssociatedComponents(Object obj) {
        if (obj instanceof Vector) {
            this.comps = (Vector)obj;
        } else {
            this.comps = new Vector();
            this.comps.addElement(obj);
        }
    }

    void clearAssociatedComponents() {
        this.comps = null;
    }

    void addAssociatedComponent(Component cmp) {
        if (this.comps == null) {
            this.comps = new Vector();
        }
        this.comps.addElement(cmp);
    }

    public void addChild(Element childElement) {
        super.addChild(childElement);
    }

    private boolean supportsCoreAttributes() {
        return this.id != 54 && this.id != 49 && this.id != 1 && this.id != 2 && this.id != 3 && this.id != 48 && this.id != 51;
    }

    public int setAttribute(String attribute, String value) {
        if (this.id == -1) {
            return -1;
        }
        int attrId = -1;
        int i = 0;
        if (this.supportsCoreAttributes()) {
            while (attrId == -1 && i < COMMON_ATTRIBUTES.length) {
                if (ATTRIBUTE_NAMES[COMMON_ATTRIBUTES[i]].equals(attribute)) {
                    attrId = COMMON_ATTRIBUTES[i];
                    continue;
                }
                ++i;
            }
        }
        i = 0;
        while (attrId == -1 && i < TAG_ATTRIBUTES[this.id].length) {
            if (ATTRIBUTE_NAMES[TAG_ATTRIBUTES[this.id][i]].equals(attribute)) {
                attrId = TAG_ATTRIBUTES[this.id][i];
                continue;
            }
            ++i;
        }
        if (attrId == -1) {
            return 1;
        }
        if (!this.isValid(ATTRIBUTE_TYPES[attrId], value)) {
            return 2;
        }
        this.setAttribute(new Integer(attrId), value);
        return -1;
    }

    public String getSupportedAttributesList() {
        int a;
        if (this.id < 0 || this.id >= TAG_ATTRIBUTES.length) {
            return "Unknown";
        }
        String list = "";
        for (a = 0; a < TAG_ATTRIBUTES[this.id].length; ++a) {
            list = list + ATTRIBUTE_NAMES[TAG_ATTRIBUTES[this.id][a]] + ",";
        }
        if (this.supportsCoreAttributes()) {
            for (a = 0; a < COMMON_ATTRIBUTES.length; ++a) {
                list = list + ATTRIBUTE_NAMES[COMMON_ATTRIBUTES[a]] + ",";
            }
        }
        if (list.endsWith(",")) {
            list = list.substring(0, list.length() - 1);
        }
        if (list.equals("")) {
            list = "None";
        }
        return list;
    }

    private boolean isValid(int type, String value) {
        if (value == null) {
            return false;
        }
        if (ALLOWED_STRINGS[type] != null) {
            return this.verifyStringGroup(value, ALLOWED_STRINGS[type]);
        }
        switch (type) {
            case 0: {
                return this.verify(value, 1, null);
            }
            case 1: {
                if (value.endsWith("%")) {
                    value = value.substring(0, value.length() - 1);
                } else if (value.endsWith("px")) {
                    value = value.substring(0, value.length() - 2);
                }
                return this.verify(value, 1, null);
            }
            case 4: {
                return this.verify(value, 5, null, 1, 1);
            }
            case 2: {
                if (value.charAt(0) != '#') {
                    return this.verifyStringGroup(value, COLOR_STRINGS);
                }
                return this.verify(value.substring(1), 2, null, 3, 6);
            }
        }
        return true;
    }

    private boolean verify(String value, int allowedMask, char[] allowedChars) {
        return this.verify(value, allowedMask, allowedChars, -1, -1);
    }

    private boolean verify(String value, int allowedMask, char[] allowedChars, int minLength, int maxLength) {
        if (minLength != -1 && value.length() < minLength) {
            return false;
        }
        if (maxLength != -1 && value.length() > maxLength) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            boolean found = false;
            char ch = value.charAt(i);
            if ((allowedMask & 2) != 0 && (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f')) {
                found = true;
            }
            if ((allowedMask & 1) != 0) {
                if (ch >= '0' && ch <= '9') {
                    found = true;
                } else if (i == 0 && (ch == '-' || ch == '+')) {
                    found = true;
                }
            }
            if (!found && (allowedMask & 4) != 0 && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                found = true;
            }
            if (!found && allowedChars != null) {
                int c = 0;
                while (!found && c < allowedChars.length) {
                    if (ch == allowedChars[c]) {
                        found = true;
                        continue;
                    }
                    ++c;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    boolean verifyStringGroup(String value, String[] allowed) {
        for (int i = 0; i < allowed.length; ++i) {
            if (!value.equalsIgnoreCase(allowed[i])) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return TAG_NAMES[this.id];
    }

    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public HTMLElement getFirstChildById(int id) {
        Vector children = this.getChildren();
        if (children == null) {
            return null;
        }
        int i = 0;
        HTMLElement found = null;
        while (found == null && i < children.size()) {
            HTMLElement child = (HTMLElement)children.elementAt(i);
            if (child.getId() == id) {
                found = child;
                continue;
            }
            ++i;
        }
        return found;
    }

    public String getAttributeById(int id) {
        Hashtable attributes = this.getAttributes();
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get(new Integer(id));
    }

    public String toString() {
        return this.toString("");
    }

    public String getAttributeName(Integer attrKey) {
        return ATTRIBUTE_NAMES[attrKey];
    }

    public String getAttribute(String name) {
        Hashtable attributes = this.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < ATTRIBUTE_NAMES.length; ++i) {
                if (!name.equalsIgnoreCase(ATTRIBUTE_NAMES[i])) continue;
                return this.getAttributeById(i);
            }
        }
        return null;
    }

    private String toString(String spacing) {
        String str = spacing;
        if (!this.isTextElement()) {
            str = str + "<" + this.getName();
            Hashtable attributes = this.getAttributes();
            if (attributes != null) {
                Enumeration e = attributes.keys();
                while (e.hasMoreElements()) {
                    Integer attrKey = (Integer)e.nextElement();
                    String attrStr = this.getAttributeName(attrKey);
                    String val = (String)attributes.get(attrKey);
                    str = str + " " + attrStr + "='" + val + "' (" + attrKey + ")";
                }
            }
            str = str + ">\n";
            Vector children = this.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    str = str + ((HTMLElement)children.elementAt(i)).toString(spacing + ' ');
                }
            }
            str = str + spacing + "</" + this.getName() + ">\n";
        } else {
            str = str + this.getText() + "\n";
        }
        return str;
    }

    Vector getUi() {
        if (this.comps == null) {
            this.comps = new Vector();
            Vector children = this.getChildren();
            if (children != null) {
                Enumeration e = children.elements();
                while (e.hasMoreElements()) {
                    HTMLElement child = (HTMLElement)e.nextElement();
                    Vector childUI = child.getUi();
                    Enumeration e2 = childUI.elements();
                    while (e2.hasMoreElements()) {
                        this.comps.addElement(e2.nextElement());
                    }
                }
            }
            this.calculatedUi = true;
        }
        return this.comps;
    }

    void recalcUi() {
        if (this.calculatedUi) {
            this.comps = null;
            this.calculatedUi = false;
        }
    }

    public void removeChildAt(int index) {
        HTMLElement child = (HTMLElement)this.getChildAt(index);
        child.clearAssociatedComponents();
        super.removeChildAt(index);
    }

    private void getDescendantsByIdInternal(Vector v, int id, int depth) {
        Vector children = this.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                HTMLElement child = (HTMLElement)children.elementAt(i);
                if (depth > 0) {
                    child.getDescendantsByIdInternal(v, id, depth - 1);
                }
                if (child.getId() != id) continue;
                v.addElement(child);
            }
        }
    }

    public Vector getDescendantsById(int id, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth must be 1 or higher");
        }
        if (this.getChildren() == null) {
            return null;
        }
        Vector v = new Vector();
        this.getDescendantsByIdInternal(v, id, depth);
        return v;
    }

    public Vector getDescendantsById(int id) {
        return this.getDescendantsById(id, Integer.MAX_VALUE);
    }
}

