/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model;

import com.sun.lwuit.Form;
import com.wordsteps.model.Dictionary;
import com.wordsteps.model.DictionaryChangeListener;
import com.wordsteps.persistence.PersistenceManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class DictionaryCache
implements DictionaryChangeListener {
    private static DictionaryCache instance = new DictionaryCache();
    private Hashtable cache = new Hashtable();
    private final Object lock = new Object();

    private DictionaryCache() {
        this.initialize();
    }

    public static DictionaryCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.lock;
        synchronized (object) {
            Dictionary[] dictionaries = PersistenceManager.loadDictionaties();
            for (int i = 0; i < dictionaries.length; ++i) {
                this.cache.put(new Integer(dictionaries[i].getId()), dictionaries[i]);
                dictionaries[i].addListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDictionary(Dictionary dictionary, Form nextForm) {
        Object object = this.lock;
        synchronized (object) {
            Dictionary old = this.cache.put(new Integer(dictionary.getId()), dictionary);
            if (old == null) {
                PersistenceManager.saveDictionary(dictionary);
            }
            dictionary.addListener(this);
        }
    }

    public Dictionary[] getDictionaries() {
        Dictionary[] dics = new Dictionary[this.cache.size()];
        Enumeration e = this.cache.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            dics[i] = (Dictionary)e.nextElement();
            ++i;
        }
        return dics;
    }

    public int getDictionariesCount() {
        return this.cache.size();
    }

    public Dictionary getDictionary(Integer id) {
        return (Dictionary)this.cache.get(id);
    }

    public boolean containsDictionary(Integer id) {
        return this.cache.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dictionaryUpdated(Dictionary dic) {
        Object object = this.lock;
        synchronized (object) {
            PersistenceManager.updateDictionary(dic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dictionaryDeleted(Dictionary dic) {
        Object object = this.lock;
        synchronized (object) {
            Integer id = new Integer(dic.getId());
            this.cache.remove(id);
            PersistenceManager.removeDictionary(dic.getStorageId());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.cache.elements();
        int i = 1;
        buf.append("DictionaryCache: [\n");
        while (e.hasMoreElements()) {
            Dictionary d = (Dictionary)e.nextElement();
            buf.append("\t").append(i++).append(": ").append(d.toString());
            if (e.hasMoreElements()) {
                buf.append("\n");
                continue;
            }
            buf.append("\n]");
        }
        return buf.toString();
    }
}

