/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model;

import java.util.Hashtable;

public class Language {
    public static final Language EN = new Language("en");
    public static final Language ES = new Language("es");
    public static final Language FR = new Language("fr");
    public static final Language DE = new Language("de");
    public static final Language RU = new Language("ru");
    public static final Language IT = new Language("it");
    public static final Language PT = new Language("pt");
    private static final Hashtable lngCode2lngName = new Hashtable(){
        {
            this.put(EN, "language.en");
            this.put(ES, "language.es");
            this.put(FR, "language.fr");
            this.put(DE, "language.de");
            this.put(RU, "language.ru");
            this.put(IT, "language.it");
            this.put(PT, "language.pt");
        }
    };
    public static final Language[] values = new Language[]{EN, ES, FR, DE, RU, IT, PT};
    private String code;

    public Language(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return (String)lngCode2lngName.get(this);
    }

    public static Language parse(String code) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].getCode().equals(code)) continue;
            return values[i];
        }
        return null;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Language)) {
            return false;
        }
        return this.code.equals(((Language)obj).getCode());
    }
}

