/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.model.exercise.tasks;

import com.wordsteps.model.Word;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.WordDataSource;
import com.wordsteps.persistence.PersistenceManager;

public abstract class Task {
    private Exercise exercise;
    private Word word;
    private Object input;
    private WordDataSource dataSource;

    public Task(Exercise exercise, WordDataSource dataSource) {
        this.exercise = exercise;
        this.dataSource = dataSource;
        this.word = dataSource.getWord();
    }

    public WordDataSource getDataSource() {
        return this.dataSource;
    }

    public Exercise getExercise() {
        return this.exercise;
    }

    public Word getWord() {
        return this.word;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public abstract Object getStatement();

    public abstract boolean isCorrect();

    public abstract void applyHint();

    public boolean check() {
        if (this.isCorrect()) {
            this.word.addExercise(this.exercise.getId());
            PersistenceManager.updateDictionary(this.exercise.getDictionary());
            return true;
        }
        return false;
    }
}

