/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen.exercise;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.ui.common.Constants;
import com.wordsteps.ui.common.TransparentLabel;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.screen.exercise.ExerciseForm;

public class FlashCardsExerciseForm
extends ExerciseForm {
    private TransparentLabel wordCounter = new TransparentLabel("");
    private Label sourceWord;
    private Button targetWord;
    private boolean translationIsShown;

    public FlashCardsExerciseForm(Exercise exercise) {
        super(exercise);
        this.wordCounter.setAlignment(3);
        this.sourceWord = new Label("");
        this.sourceWord.setAlignment(4);
        this.sourceWord.getStyle().setBgColor(15333118);
        this.sourceWord.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914));
        UIProfile.applyFont(this.sourceWord.getStyle(), "exercise.statement.font");
        UIProfile.applyPadding(this.sourceWord.getStyle(), "exercise.statement.padding");
        this.targetWord = new Button("");
        this.targetWord.setAlignment(4);
        this.targetWord.getStyle().setBgColor(15333118, true);
        this.targetWord.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914), true);
        UIProfile.applyFont(this.targetWord.getStyle(), "flash.cards.show.translation.font");
        UIProfile.applyPadding(this.targetWord.getStyle(), "flash.cards.show.translation.padding");
        this.targetWord.setSelectedStyle(this.targetWord.getStyle());
        this.targetWord.getPressedStyle().setBgColor(9093861);
        this.targetWord.getPressedStyle().setBorder(Border.createRoundBorder(15, 15, 5935024));
        this.targetWord.getPressedStyle().setFgColor(0xFFFFFF);
        UIProfile.applyFont(this.targetWord.getPressedStyle(), "flash.cards.show.translation.font");
        UIProfile.applyPadding(this.targetWord.getPressedStyle(), "flash.cards.show.translation.padding");
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    private void createComponents() {
        this.addComponent(this.getDescriptionComponent());
        this.addComponent(this.sourceWord);
        this.addComponent(this.targetWord);
        this.addComponent(this.wordCounter);
    }

    public void createCommands() {
        Command okCommand = new Command("command.ok", 3){

            public void actionPerformed(ActionEvent evt) {
                if (!FlashCardsExerciseForm.this.translationIsShown) {
                    FlashCardsExerciseForm.this.targetWord.setText(FlashCardsExerciseForm.this.tasks[FlashCardsExerciseForm.this.currentTask].getWord().getTranslation());
                    FlashCardsExerciseForm.this.targetWord.getSelectedStyle().setBgColor(0xFFFFE0);
                    FlashCardsExerciseForm.this.translationIsShown = true;
                } else {
                    FlashCardsExerciseForm.this.checkInput(FlashCardsExerciseForm.this.targetWord.getText(), false);
                }
            }
        };
        this.addCommand(new Command("command.back", 1){

            public void actionPerformed(ActionEvent evt) {
                if (FlashCardsExerciseForm.this.getPreviousScreenForm() != null) {
                    FlashCardsExerciseForm.this.getPreviousScreenForm().show();
                }
            }
        }, 0);
        this.addCommand(Constants.NULL_COMMAND_0, 1);
        this.targetWord.setSelectCommandText(UIManager.getInstance().localize("command.ok", "[NULl]"));
        this.targetWord.addActionListener(okCommand);
    }

    protected void initState() {
        this.currentTask = 0;
    }

    protected void displayCurrentState() {
        super.displayCurrentState();
        this.sourceWord.setText(this.tasks[this.currentTask].getWord().getWord());
        this.targetWord.setText("flash.cards.show.translation");
        this.targetWord.getSelectedStyle().setBgColor(15333118);
        this.translationIsShown = false;
    }
}

