/*
 * Decompiled with CFR 0.152.
 */
package com.wordsteps.ui.screen.exercise;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.wordsteps.model.exercise.Exercise;
import com.wordsteps.model.exercise.tasks.Task;
import com.wordsteps.ui.common.UIProfile;
import com.wordsteps.ui.dialogs.ButtonDialog;
import com.wordsteps.ui.screen.exercise.ExerciseForm;
import com.wordsteps.ui.util.FontRegistry;
import com.wordsteps.ui.util.ImageRegistry;

public class TranslateExerciseForm
extends ExerciseForm {
    private Label sourceWord = new Label("");
    private TextArea targetWord;
    private boolean hintMode;
    private Button hint;

    public TranslateExerciseForm(Exercise exercise, Form prevForm) {
        super(exercise, prevForm);
        this.sourceWord.getStyle().setBgColor(15333118);
        this.sourceWord.getStyle().setBorder(Border.createRoundBorder(15, 15, 12508914));
        UIProfile.applyFont(this.sourceWord.getStyle(), "exercise.statement.font");
        UIProfile.applyPadding(this.sourceWord.getStyle(), "exercise.statement.padding");
        this.targetWord = new TextArea();
        this.targetWord.setSingleLineTextArea(true);
        this.targetWord.getSelectedStyle().setBorder(Border.createLineBorder(1, 5935024));
        this.targetWord.getSelectedStyle().setBgColor(14608594);
        this.targetWord.setSelectCommandText(UIManager.getInstance().localize("command.select", "[NULL]"));
        UIProfile.applyFont(this.targetWord.getStyle(), "translation.font");
        UIProfile.applyPadding(this.targetWord.getStyle(), "translation.padding");
        UIProfile.applyFont(this.targetWord.getSelectedStyle(), "translation.font");
        UIProfile.applyPadding(this.targetWord.getSelectedStyle(), "translation.padding");
        this.hintMode = true;
        this.hint = new Button("wbt.hint");
        this.hint.setSelectCommandText(UIManager.getInstance().localize("command.select", "[NULL]"));
        this.hint.setAlignment(4);
        this.hint.getStyle().setFgColor(0xFFFFFF);
        this.hint.getStyle().setBorder(Border.createLineBorder(1, 5935024));
        this.hint.getStyle().setBgColor(9093861);
        this.hint.getSelectedStyle().setFgColor(0xFFFFFF);
        this.hint.getSelectedStyle().setBgColor(5935024);
        this.hint.getSelectedStyle().setBorder(Border.createLineBorder(1, 5935024));
        this.hint.setPressedStyle(this.hint.getSelectedStyle());
        UIProfile.applyFont(this.hint.getSelectedStyle(), "hint.font");
        UIProfile.applyPadding(this.hint.getSelectedStyle(), "hint.padding");
        UIProfile.applyFont(this.hint.getStyle(), "hint.font");
        UIProfile.applyPadding(this.hint.getStyle(), "hint.padding");
        this.setLayout(new BoxLayout(2));
        this.createComponents();
        this.createCommands();
    }

    public TranslateExerciseForm(Exercise exercise) {
        this(exercise, null);
    }

    private void createComponents() {
        this.addComponent(this.getDescriptionComponent());
        this.sourceWord.getStyle().setFont(FontRegistry.BOLD_MEDIUM);
        this.sourceWord.setAlignment(4);
        this.addComponent(this.sourceWord);
        this.addComponent(this.targetWord);
        this.addComponent(this.hint);
        this.hint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (TranslateExerciseForm.this.hintMode) {
                    Task task = TranslateExerciseForm.this.tasks[TranslateExerciseForm.this.currentTask];
                    task.setInput(TranslateExerciseForm.this.targetWord.getText());
                    task.applyHint();
                    TranslateExerciseForm.this.targetWord.setText(task.getInput().toString());
                    if (task.isCorrect()) {
                        TranslateExerciseForm.this.hint.setText("wbt.next.word");
                        TranslateExerciseForm.this.hintMode = false;
                    }
                } else {
                    TranslateExerciseForm.this.hintMode = true;
                    TranslateExerciseForm.this.hint.setText("wbt.hint");
                    TranslateExerciseForm.this.checkInput(TranslateExerciseForm.this.targetWord.getText());
                }
            }
        });
    }

    public void createCommands() {
        Command check = new Command("command.check", 13){

            public void actionPerformed(ActionEvent evt) {
                if (TranslateExerciseForm.this.targetWord.getText().length() > 0) {
                    TranslateExerciseForm.this.checkInput(TranslateExerciseForm.this.targetWord.getText().toLowerCase());
                } else {
                    new ButtonDialog(UIManager.getInstance().localize("exercise.empty.answer", "[NULL]"), ImageRegistry.getImage("information")).showPacked("Center", true);
                }
            }
        };
        this.addCommand(new Command("command.back", 1){

            public void actionPerformed(ActionEvent evt) {
                if (TranslateExerciseForm.this.getPreviousScreenForm() != null) {
                    TranslateExerciseForm.this.getPreviousScreenForm().show();
                }
            }
        }, 0);
        this.addCommand(check, 1);
    }

    protected void initState() {
        this.currentTask = 0;
        for (int i = 0; i < this.tasks.length; ++i) {
            this.tasks[i].setInput(null);
        }
    }

    protected void displayCurrentState() {
        super.displayCurrentState();
        this.targetWord.setText("");
        this.sourceWord.setText((String)this.tasks[this.currentTask].getStatement());
        this.hintMode = true;
        this.hint.setText("wbt.hint");
    }
}

